/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableIndexInfo {
    private static Map<String, Set<IndexDescription>> map = new HashMap<String, Set<IndexDescription>>();

    private static void addIndexDescription(String tableName, String columnName) {
        Set<IndexDescription> set = map.get(tableName);
        if (set == null) {
            set = new HashSet<IndexDescription>();
            map.put(tableName, set);
        }
        set.add(new IndexDescription(columnName));
    }

    public static IndexDescription[] getIndexesForTable(String tableName) {
        if (!map.containsKey(tableName)) {
            return new IndexDescription[0];
        }
        return map.get(tableName).toArray(new IndexDescription[0]);
    }

    static {
        TableIndexInfo.addIndexDescription("ConstantSets", "ParentID");
        TableIndexInfo.addIndexDescription("ConstantSets", "ConstID");
    }

    public static class IndexDescription {
        private final String columnName;
        private final String indexName;

        IndexDescription(String columnName) {
            this.columnName = columnName;
            this.indexName = columnName + "_ix";
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }
}

