/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RelatedLinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.BaseGetWorkItemRowSetHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkItemRelationsRowSetHandler
extends BaseGetWorkItemRowSetHandler {
    private final Map<Date, Integer> data = new HashMap<Date, Integer>();

    public WorkItemRelationsRowSetHandler(WorkItemImpl workItem, IMetadata metadataManager) {
        super(workItem, metadataManager);
    }

    @Override
    protected void doHandleRow() {
        int id = this.getIntValue("ID");
        String comment = this.getStringValue("Comment");
        Date changedDate = this.getDateValue("Changed Date");
        int linkTypeId = 0;
        if (this.getWorkItem().getClient().supportsWorkItemLinkTypes()) {
            linkTypeId = this.getIntValue("LinkType");
        }
        boolean readOnly = false;
        if (this.getWorkItem().getClient().supportsReadOnlyLinkTypes()) {
            readOnly = this.getBooleanValue("Lock");
        }
        RelatedLinkImpl link = new RelatedLinkImpl(this.getWorkItem(), id, linkTypeId, comment, false, readOnly);
        this.getWorkItem().getLinksInternal().add(link);
        Integer currentCount = this.data.get(changedDate);
        if (currentCount == null) {
            this.data.put(changedDate, new Integer(1));
        } else {
            this.data.put(changedDate, new Integer(currentCount + 1));
        }
    }

    @Override
    public void handleEndParsing() {
        int currentRelatedLinkCount = 0;
        for (int i = 0; i < this.getWorkItem().getRevisionsInternal().size(); ++i) {
            RevisionImpl revision = this.getWorkItem().getRevisionsInternal().getRevisionInternal(i);
            Date revisionDate = revision.getRevisionDate();
            revision.getFieldInternal(75).setOriginalValue(new Integer(currentRelatedLinkCount));
            if (this.data.containsKey(revisionDate)) {
                Integer addedAtThisRevisionCount = this.data.get(revisionDate);
                currentRelatedLinkCount += addedAtThisRevisionCount.intValue();
            }
            revision.getFieldInternal(75).setNewValue(new Integer(currentRelatedLinkCount));
        }
    }
}

