/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.util.LangUtils;

public class UsernamePasswordCredentials
extends Credentials {
    private final String username;
    private String password;
    private final Object passwordLock = new Object();

    public UsernamePasswordCredentials(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Username may not be null");
        }
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        Object object = this.passwordLock;
        synchronized (object) {
            this.password = password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        Object object = this.passwordLock;
        synchronized (object) {
            return this.password;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.username);
        result.append(":");
        result.append(this.password == null ? "null" : this.password);
        return result.toString();
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.username);
        hash = LangUtils.hashCode(hash, this.password);
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
            if (LangUtils.equals(this.username, that.username) && LangUtils.equals(this.password, that.password)) {
                return true;
            }
        }
        return false;
    }

    public static class PatCredentials
    extends UsernamePasswordCredentials {
        public static final String USERNAME_FOR_CODE_ACCESS_PAT = "_VSTS_Code_Access_Token_";
        public static final String TOKEN_DESCRIPTION = "TEE: {0} on: {1}";

        public PatCredentials(String pat) {
            super(USERNAME_FOR_CODE_ACCESS_PAT, pat == null ? "" : pat);
        }
    }
}

