/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.diffmerge.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.TypesafeEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class libsgdcore_lite {
    private static final Log log = LogFactory.getLog(libsgdcore_lite.class);
    private final tree_t tree = new tree_t();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SGD_MergeResult _do_merge(String original, Charset originalEnc, String modified, Charset modifiedEnc, String latest, Charset latestEnc, String result, String eol) {
        svn_diff_t pDiff = null;
        Charset[] outEnc = new Charset[1];
        String[] outEol = new String[1];
        boolean[] trailingNewline = new boolean[]{true};
        try {
            pDiff = libsgdcore_lite.svn_diff3_file(original, originalEnc, modified, modifiedEnc, latest, latestEnc, outEnc, outEol, trailingNewline);
            if (eol == null) {
                eol = outEol[0];
            }
        }
        catch (Exception e) {
            return SGD_MergeResult.SGD_MergeResult_Error;
        }
        if (libsgdcore_lite.contains_conflicts(pDiff)) {
            return SGD_MergeResult.SGD_MergeResult_Conflicts;
        }
        try {
            File fi = new File(result);
            FileOutputStream fos = new FileOutputStream(fi);
            OutputStreamWriter encWriter = new OutputStreamWriter((OutputStream)fos, outEnc[0]);
            BufferedWriter pFileResult = new BufferedWriter(encWriter);
            try {
                libsgdcore_lite.svn_diff3_file_output(pFileResult, pDiff, eol, trailingNewline[0], original, originalEnc, modified, modifiedEnc, latest, latestEnc, null, null, null, null, true, false);
            }
            finally {
                pFileResult.close();
            }
        }
        catch (Exception e) {
            return SGD_MergeResult.SGD_MergeResult_Error;
        }
        SGD_MergeResult mr = libsgdcore_lite.contains_diffs(pDiff) ? SGD_MergeResult.SGD_MergeResult_Differences : SGD_MergeResult.SGD_MergeResult_Identical;
        return mr;
    }

    public static SGD_MergeResult _test_merge(String original, Charset originalEnc, String modified, Charset modifiedEnc, String latest, Charset latestEnc, int[] numConflicts) {
        numConflicts[0] = 0;
        svn_diff_t pDiff = null;
        try {
            pDiff = libsgdcore_lite.svn_diff3_file(original, originalEnc, modified, modifiedEnc, latest, latestEnc, new Charset[1], new String[1], new boolean[1]);
        }
        catch (Exception e) {
            return SGD_MergeResult.SGD_MergeResult_Error;
        }
        numConflicts[0] = libsgdcore_lite.count_conflicts(pDiff);
        if (numConflicts[0] > 0) {
            return SGD_MergeResult.SGD_MergeResult_Conflicts;
        }
        SGD_MergeResult mr = libsgdcore_lite.contains_diffs(pDiff) ? SGD_MergeResult.SGD_MergeResult_Differences : SGD_MergeResult.SGD_MergeResult_Identical;
        return mr;
    }

    public static void svn_diff3_file_output(Writer output_file, svn_diff_t diff, String eol, boolean trailingEol, String original_path, Charset original_charset, String modified_path, Charset modified_charset, String latest_path, Charset latest_charset, String conflict_original, String conflict_modified, String conflict_latest, String conflict_separator, boolean display_original_in_conflict, boolean display_resolved_conflicts) {
        file_output_baton_t baton = new file_output_baton_t();
        baton.output_file = output_file;
        baton.path[0] = original_path;
        baton.path[1] = modified_path;
        baton.path[2] = latest_path;
        Charset[] charsets = new Charset[]{original_charset, modified_charset, latest_charset};
        baton.conflict_modified = conflict_modified != null ? conflict_modified : "<<<<<<< " + modified_path;
        baton.conflict_original = conflict_original != null ? conflict_original : "||||||| " + original_path;
        baton.conflict_separator = conflict_separator != null ? conflict_separator : "=======";
        baton.conflict_latest = conflict_latest != null ? conflict_latest : ">>>>>>> " + latest_path;
        baton.display_original_in_conflict = display_original_in_conflict;
        baton.display_resolved_conflicts = display_resolved_conflicts && !display_original_in_conflict;
        baton.setEOL(eol);
        baton.setTrailingEol(trailingEol);
        for (int idx = 0; idx < 3; ++idx) {
            baton.buffer[idx] = file_baton_t.GetLines(baton.path[idx], idx, new Charset[]{charsets[idx]}, new String[1], new boolean[1]);
            baton.curp[idx] = 0;
            baton.endp[idx] = baton.buffer[idx].length;
        }
        output_fns_t vtable = new output_fns_t(baton);
        libsgdcore_lite.svn_diff_output(diff, vtable);
    }

    public static void svn_diff_output(svn_diff_t diff, output_fns_t vtable) {
        while (diff != null) {
            boolean lastDiff;
            boolean bl = lastDiff = diff.next == null;
            if (diff.type.equals(type_e.type_common)) {
                vtable.output_common(diff.m_start[0], diff.m_length[0], diff.m_start[1], diff.m_length[1], diff.m_start[2], diff.m_length[2], lastDiff);
            } else if (diff.type.equals(type_e.type_diff_common)) {
                vtable.output_diff_common(diff.m_start[0], diff.m_length[0], diff.m_start[1], diff.m_length[1], diff.m_start[2], diff.m_length[2], lastDiff);
            } else if (diff.type.equals(type_e.type_diff_modified)) {
                vtable.output_diff_modified(diff.m_start[0], diff.m_length[0], diff.m_start[1], diff.m_length[1], diff.m_start[2], diff.m_length[2], lastDiff);
            } else if (diff.type.equals(type_e.type_diff_latest)) {
                vtable.output_diff_latest(diff.m_start[0], diff.m_length[0], diff.m_start[1], diff.m_length[1], diff.m_start[2], diff.m_length[2], lastDiff);
            } else if (diff.type.equals(type_e.type_conflict)) {
                vtable.output_conflict(diff.m_start[0], diff.m_length[0], diff.m_start[1], diff.m_length[1], diff.m_start[2], diff.m_length[2], diff.resolved_diff, lastDiff);
            }
            diff = diff.next;
        }
    }

    public static boolean contains_diffs(svn_diff_t diff) {
        while (diff != null) {
            if (diff.type != type_e.type_common) {
                return true;
            }
            diff = diff.next;
        }
        return false;
    }

    public static boolean contains_conflicts(svn_diff_t diff) {
        while (diff != null) {
            if (diff.type == type_e.type_conflict) {
                return true;
            }
            diff = diff.next;
        }
        return false;
    }

    public static int count_conflicts(svn_diff_t diff) {
        int count = 0;
        while (diff != null) {
            if (diff.type == type_e.type_conflict) {
                ++count;
            }
            diff = diff.next;
        }
        return count;
    }

    public static int count_type(svn_diff_t diff, type_e t) {
        int count = 0;
        while (diff != null) {
            if (diff.type == t) {
                ++count;
            }
            diff = diff.next;
        }
        return count;
    }

    public static svn_diff_t svn_diff3_file(String original, Charset originalEnc, String modified, Charset modifiedEnc, String latest, Charset latestEnc, Charset[] outputEnc, String[] outputEol, boolean[] hasTrailingNewline) {
        file_baton_t baton = new file_baton_t();
        baton.path[0] = original;
        baton.enc[0] = originalEnc;
        baton.path[1] = modified;
        baton.enc[1] = modifiedEnc;
        baton.path[2] = latest;
        baton.enc[2] = latestEnc;
        svn_diff_fns_t vtable = new svn_diff_fns_t(baton);
        return libsgdcore_lite.svn_diff3(vtable, outputEnc, outputEol, hasTrailingNewline);
    }

    private static void get_tokens(position_t[] position_list, int position_idx, tree_t[] tree, svn_diff_fns_t vtable, svn_diff_datasource_e datasource) {
        position_t start_position = null;
        position_t position = null;
        position_t prev = null;
        position_list[position_idx] = null;
        vtable.datasource_open(datasource);
        position_t position_ref = start_position;
        int offset = 0;
        file_token_t token = null;
        node_t ref_node = null;
        if (tree[0].root == null) {
            tree[0].root = ref_node;
        }
        while (true) {
            file_token_t[] reftoken = new file_token_t[]{token};
            vtable.datasource_get_next_token(reftoken, datasource);
            token = reftoken[0];
            if (token == null) break;
            node_t node = libsgdcore_lite.tree_insert_token(tree, ref_node, vtable, token);
            position = new position_t();
            position.next = null;
            position.node = node;
            position.offset = ++offset;
            position.prev = prev;
            prev = position;
            if (position_ref != null) {
                position_ref.next = position;
            }
            if (start_position == null) {
                start_position = position;
            }
            position_ref = position;
        }
        position_ref = start_position;
        if (start_position != null) {
            start_position.prev = position;
            position.next = start_position;
        }
        position_list[position_idx] = position;
        if (position != null) {
            int maxoff = position.offset;
            position_t tmp = position_list[position_idx];
            while (tmp != null) {
                tmp.maxoffset = maxoff;
                tmp = tmp.next;
                if (tmp.offset < maxoff) continue;
                break;
            }
        }
    }

    private static node_t tree_insert_token(tree_t[] tree, node_t ref_node, svn_diff_fns_t vtable, file_token_t token) {
        int rv;
        node_t node = new node_t();
        node_t temp = tree[0].root;
        while (temp != ref_node) {
            node.parent = temp;
            rv = vtable.token_compare(node.parent.token, token);
            if (rv == 0) {
                vtable.file_token_discard(token);
                return temp;
            }
            if (rv > 0) {
                temp = temp.left;
                continue;
            }
            temp = temp.right;
        }
        node.left = null;
        node.right = null;
        node.token = token;
        if (node.parent != null) {
            rv = vtable.token_compare(node.parent.token, node.token);
            if (rv > 0) {
                node.parent.left = node;
            } else {
                node.parent.right = node;
            }
        } else {
            tree[0].root = node;
        }
        return node;
    }

    private static void snake(int k, snake_t[] fp, int idx) {
        lcs_t previous_lcs;
        position_t start_position_0 = null;
        position_t start_position_1 = null;
        position_t position_0 = null;
        position_t position_1 = null;
        if (fp[k - 1].y + 1 > fp[k + 1].y) {
            start_position_0 = fp[k - 1].position[0];
            start_position_1 = fp[k - 1].position[1].next;
            previous_lcs = fp[k - 1].lcs;
        } else {
            start_position_0 = fp[k + 1].position[0].next;
            start_position_1 = fp[k + 1].position[1];
            previous_lcs = fp[k + 1].lcs;
        }
        position_0 = start_position_0;
        position_1 = start_position_1;
        if (position_0.node != null && position_1.node != null) {
            while (position_0.node == position_1.node) {
                position_0 = position_0.next;
                position_1 = position_1.next;
                if (position_0.offset <= position_0.maxoffset && position_1.offset <= position_1.maxoffset) continue;
            }
        }
        if (position_1 != start_position_1) {
            lcs_t lcs = new lcs_t();
            lcs.position[idx] = start_position_0;
            lcs.position[Math.abs((int)(1 - idx))] = start_position_1;
            lcs.length = position_1.offset - start_position_1.offset;
            lcs.next = previous_lcs;
            fp[k].lcs = lcs;
        } else {
            fp[k].lcs = previous_lcs;
        }
        fp[k].position[0] = position_0;
        fp[k].position[1] = position_1;
        fp[k].y = position_1.offset;
    }

    private static lcs_t lcs_reverse(lcs_t lcs) {
        lcs_t next = null;
        while (lcs != null) {
            lcs_t prev = lcs.next;
            lcs.next = next;
            next = lcs;
            lcs = prev;
        }
        return next;
    }

    private static int lcs_juggle(lcs_t[] lcsHead) {
        int bDidJuggling = 0;
        lcs_t lcs = lcsHead[0];
        while (lcs != null && lcs.next != null) {
            int k;
            lcs_t lcsNext = lcs.next;
            if (lcsNext.length == 0) {
                lcs = lcs.next;
                continue;
            }
            int lenGap0 = lcsNext.position[0].offset - lcs.position[0].offset - lcs.length;
            int lenGap1 = lcsNext.position[1].offset - lcs.position[1].offset - lcs.length;
            if (lenGap0 == 0 && lenGap1 == 0) {
                lcs = lcs.next;
                continue;
            }
            if (lenGap0 > 0 && lenGap1 > 0) {
                lcs = lcs.next;
                continue;
            }
            int ndxGap = lenGap1 > 0 ? 1 : 0;
            position_t pGapTail = lcsNext.position[ndxGap];
            for (k = 0; k < lcs.length; ++k) {
                pGapTail = pGapTail.prev;
            }
            boolean noshift = false;
            position_t pBegin = lcs.position[ndxGap];
            position_t pEnd = pGapTail;
            for (k = 0; k < lcs.length; ++k) {
                if (pBegin.node != pEnd.node) {
                    noshift = true;
                    break;
                }
                pBegin = pBegin.next;
                pEnd = pEnd.next;
            }
            if (noshift) {
                lcs = lcs.next;
                continue;
            }
            lcs.position[ndxGap] = pGapTail;
            if (lcsNext.length <= 0) continue;
            lcs.length += lcsNext.length;
            lcs.next = lcsNext.next;
            bDidJuggling = 1;
        }
        return bDidJuggling;
    }

    private static lcs_t lcs(position_t position_list1, position_t position_list2) {
        int[] length = new int[2];
        int p = 0;
        position_t[] sentinel_position = new position_t[2];
        node_t[] sentinel_node = new node_t[2];
        lcs_t lcs = new lcs_t();
        lcs.position[0] = new position_t();
        lcs.position[0].offset = position_list1 != null ? position_list1.offset + 1 : 1;
        lcs.position[1] = new position_t();
        lcs.position[1].offset = position_list2 != null ? position_list2.offset + 1 : 1;
        lcs.length = 0;
        lcs.next = null;
        if (position_list1 == null || position_list2 == null) {
            return lcs;
        }
        length[0] = position_list1.offset - position_list1.next.offset + 1;
        length[1] = position_list2.offset - position_list2.next.offset + 1;
        int idx = length[0] > length[1] ? 1 : 0;
        snake_t[] fp = new snake_t[length[0] + length[1] + 3];
        for (int i = 0; i < fp.length; ++i) {
            fp[i] = new snake_t();
        }
        sentinel_position[idx] = new position_t();
        sentinel_position[idx].next = position_list1.next;
        position_list1.next = sentinel_position[idx];
        sentinel_position[idx].offset = position_list1.offset + 1;
        sentinel_position[Math.abs((int)(1 - idx))] = new position_t();
        sentinel_position[Math.abs((int)(1 - idx))].next = position_list2.next;
        position_list2.next = sentinel_position[Math.abs(1 - idx)];
        sentinel_position[Math.abs((int)(1 - idx))].offset = position_list2.offset + 1;
        sentinel_position[0].node = sentinel_node[0];
        sentinel_position[1].node = sentinel_node[1];
        int d = length[Math.abs(1 - idx)] - length[idx];
        int x = length[idx] + 1;
        fp[x - 1] = new snake_t();
        fp[x - 1].position[0] = sentinel_position[0].next;
        fp[x - 1].position[1] = sentinel_position[1];
        p = 0;
        do {
            int k;
            for (k = x - p; k < x + d; ++k) {
                libsgdcore_lite.snake(k, fp, idx);
            }
            for (k = d + x + p; k >= x + d; --k) {
                libsgdcore_lite.snake(k, fp, idx);
            }
            ++p;
        } while (fp[d + x].position[1] != sentinel_position[1]);
        lcs.next = fp[d + x].lcs;
        lcs = libsgdcore_lite.lcs_reverse(lcs);
        position_list1.next = sentinel_position[idx].next;
        position_list2.next = sentinel_position[Math.abs((int)(1 - idx))].next;
        lcs_t[] reflcs = new lcs_t[]{lcs};
        while (libsgdcore_lite.lcs_juggle(reflcs) > 0) {
        }
        lcs = reflcs[0];
        return lcs;
    }

    private static svn_diff_t svn_diff3(svn_diff_fns_t vtable, Charset[] enc, String[] eol, boolean[] hasTrailingNewline) {
        tree_t tree = new tree_t();
        position_t[] position_list = new position_t[3];
        tree_t[] reftree = new tree_t[]{tree};
        libsgdcore_lite.get_tokens(position_list, 0, reftree, vtable, svn_diff_datasource_e.svn_diff_datasource_original);
        libsgdcore_lite.get_tokens(position_list, 1, reftree, vtable, svn_diff_datasource_e.svn_diff_datasource_modified);
        libsgdcore_lite.get_tokens(position_list, 2, reftree, vtable, svn_diff_datasource_e.svn_diff_datasource_latest);
        enc[0] = vtable.ComputeBestEncoding();
        eol[0] = vtable.ComputeBestLineEnding();
        hasTrailingNewline[0] = vtable.ComputeBestTrailingEol();
        tree = reftree[0];
        vtable.file_token_discard_all();
        lcs_t lcs_om = libsgdcore_lite.lcs(position_list[0], position_list[1]);
        lcs_t lcs_ol = libsgdcore_lite.lcs(position_list[0], position_list[2]);
        return libsgdcore_lite.svn_diff3__diff3(lcs_om, lcs_ol, 1, 1, 1, position_list);
    }

    /*
     * Unable to fully structure code
     */
    public static svn_diff_t svn_diff3__diff3(lcs_t lcs_om, lcs_t lcs_ol, int original_start, int modified_start, int latest_start, position_t[] position_list) {
        diff = null;
        diff_ref = null;
        sentinel_position = new position_t[]{new position_t(), new position_t()};
        if (position_list[1] != null) {
            sentinel_position[0].next = position_list[1].next;
            sentinel_position[0].offset = position_list[1].offset + 1;
            position_list[1].next = sentinel_position[0];
            position_list[1] = sentinel_position[0].next;
        } else {
            sentinel_position[0].offset = 1;
            sentinel_position[0].next = null;
            position_list[1] = sentinel_position[0];
            position_list[1].maxoffset = 1;
        }
        if (position_list[2] != null) {
            sentinel_position[1].next = position_list[2].next;
            sentinel_position[1].offset = position_list[2].offset + 1;
            position_list[2].next = sentinel_position[1];
            position_list[2] = sentinel_position[1].next;
        } else {
            sentinel_position[1].offset = 1;
            sentinel_position[1].next = null;
            position_list[2] = sentinel_position[1];
            position_list[2].maxoffset = 1;
        }
        block0: while (true) {
            if (lcs_om.position[0].offset > lcs_ol.position[0].offset) {
                original_sync = lcs_om.position[0].offset;
                while (lcs_ol.position[0].offset + lcs_ol.length < original_sync) {
                    lcs_ol = lcs_ol.next;
                }
                if (lcs_om.length == 0 && lcs_ol.length > 0 && lcs_ol.position[0].offset + lcs_ol.length == original_sync && lcs_ol.position[1].offset + lcs_ol.length != lcs_ol.next.position[1].offset) {
                    lcs_ol = lcs_ol.next;
                }
                if (lcs_ol.position[0].offset > original_sync) continue;
            } else {
                original_sync = lcs_ol.position[0].offset;
                while (lcs_om.position[0].offset + lcs_om.length < original_sync) {
                    lcs_om = lcs_om.next;
                }
                if (lcs_ol.length == 0 && lcs_om.length > 0 && lcs_om.position[0].offset + lcs_om.length == original_sync && lcs_om.position[1].offset + lcs_om.length != lcs_om.next.position[1].offset) {
                    lcs_om = lcs_om.next;
                }
                if (lcs_om.position[0].offset > original_sync) continue;
            }
            modified_sync = lcs_om.position[1].offset + (original_sync - lcs_om.position[0].offset);
            latest_sync = lcs_ol.position[1].offset + (original_sync - lcs_ol.position[0].offset);
            is_modified = lcs_om.position[0].offset - original_start > 0 || lcs_om.position[1].offset - modified_start > 0;
            v0 = is_latest = lcs_ol.position[0].offset - original_start > 0 || lcs_ol.position[1].offset - latest_start > 0;
            if (is_modified || is_latest) {
                modified_length = modified_sync - modified_start;
                latest_length = latest_sync - latest_start;
                dr = new svn_diff_t();
                dr.m_start[0] = original_start - 1;
                dr.m_length[0] = original_sync - original_start;
                dr.m_start[1] = modified_start - 1;
                dr.m_length[1] = modified_length;
                dr.m_start[2] = latest_start - 1;
                dr.m_length[2] = latest_length;
                dr.resolved_diff = null;
                if (is_modified && is_latest) {
                    refdr = new svn_diff_t[]{dr};
                    libsgdcore_lite.resolve_conflict(refdr, position_list);
                    dr = refdr[0];
                } else {
                    dr.type = is_modified != false ? type_e.type_diff_modified : type_e.type_diff_latest;
                }
                if (diff == null) {
                    diff = dr;
                    diff_ref = dr;
                } else {
                    diff_ref.next = dr;
                    diff_ref = dr;
                }
            }
            if (lcs_om.length == 0 || lcs_ol.length == 0) break;
            modified_length = lcs_om.length - (original_sync - lcs_om.position[0].offset);
            latest_length = lcs_ol.length - (original_sync - lcs_ol.position[0].offset);
            common_length = modified_length < latest_length ? modified_length : latest_length;
            dn = new svn_diff_t();
            dn.type = type_e.type_common;
            dn.m_start[0] = original_sync - 1;
            dn.m_length[0] = common_length;
            dn.m_start[1] = modified_sync - 1;
            dn.m_length[1] = common_length;
            dn.m_start[2] = latest_sync - 1;
            dn.m_length[2] = common_length;
            dn.resolved_diff = null;
            if (diff == null) {
                diff = dn;
                diff_ref = dn;
            } else {
                diff_ref.next = dn;
                diff_ref = dn;
            }
            original_start = original_sync + common_length;
            modified_start = modified_sync + common_length;
            latest_start = latest_sync + common_length;
            if (position_list[1].offset < lcs_om.position[1].offset) {
                position_list[1] = lcs_om.position[1];
            }
            if (position_list[2].offset < lcs_ol.position[1].offset) {
                position_list[2] = lcs_ol.position[1];
            }
            while (original_start >= lcs_om.position[0].offset + lcs_om.length && lcs_om.length > 0) {
                lcs_om = lcs_om.next;
            }
            while (true) {
                if (original_start >= lcs_ol.position[0].offset + lcs_ol.length && lcs_ol.length > 0) ** break;
                continue block0;
                lcs_ol = lcs_ol.next;
            }
            break;
        }
        diff_ref = null;
        return diff;
    }

    public static void resolve_conflict(svn_diff_t[] hunk, position_t[] position_list) {
        int common_length;
        lcs_t lcs_x;
        int modified_start = hunk[0].m_start[1] + 1;
        int latest_start = hunk[0].m_start[2] + 1;
        int modified_length = hunk[0].m_length[1];
        int latest_length = hunk[0].m_length[2];
        position_t[] start_position = new position_t[2];
        position_t[] position = new position_t[2];
        lcs_t lcs_ref = lcs_x = null;
        svn_diff_t diff_ref = null;
        start_position[0] = position_list[1];
        start_position[1] = position_list[2];
        while (start_position[0].offset < modified_start) {
            start_position[0] = start_position[0].next;
        }
        while (start_position[1].offset < latest_start) {
            start_position[1] = start_position[1].next;
        }
        position[0] = start_position[0];
        position[1] = start_position[1];
        int n = common_length = modified_length < latest_length ? modified_length : latest_length;
        while (common_length > 0 && position[0].node == position[1].node) {
            position[0] = position[0].next;
            position[1] = position[1].next;
            --common_length;
        }
        if (common_length == 0 && modified_length == latest_length) {
            hunk[0].type = type_e.type_diff_common;
            hunk[0].resolved_diff = null;
            position_list[1] = position[0];
            position_list[2] = position[1];
            return;
        }
        hunk[0].type = type_e.type_conflict;
        common_length = (modified_length < latest_length ? modified_length : latest_length) - common_length;
        if (common_length > 0) {
            lcs_t lr = new lcs_t();
            lr.next = null;
            lr.position[0] = start_position[0];
            lr.position[1] = start_position[1];
            lr.length = common_length;
            if (lcs_x == null) {
                lcs_x = lr;
                lcs_ref = lr;
            } else {
                lcs_ref.next = lr;
                lcs_ref = lr;
            }
        }
        modified_length -= common_length;
        latest_length -= common_length;
        modified_start = start_position[0].offset;
        latest_start = start_position[1].offset;
        start_position[0] = position[0];
        start_position[1] = position[1];
        if (modified_length == 0) {
            position_list[1] = position[0];
            position[0] = null;
        } else {
            while (--modified_length > 0) {
                position[0] = position[0].next;
            }
            position_list[1] = position[0].next;
            position[0].next = start_position[0];
        }
        if (latest_length == 0) {
            position_list[2] = position[1];
            position[1] = null;
        } else {
            while (--latest_length > 0) {
                position[1] = position[1].next;
            }
            position_list[2] = position[1].next;
            position[1].next = start_position[1];
        }
        lcs_ref = libsgdcore_lite.lcs(position[0], position[1]);
        if (lcs_ref.position[0].offset == 1) {
            lcs_ref.position[0] = position_list[1];
        }
        if (lcs_ref.position[1].offset == 1) {
            lcs_ref.position[1] = position_list[2];
        }
        modified_length = hunk[0].m_length[1];
        latest_length = hunk[0].m_length[2];
        lcs_x = lcs_ref;
        while (true) {
            if (modified_start < lcs_x.position[0].offset || latest_start < lcs_x.position[1].offset) {
                svn_diff_t dr = new svn_diff_t();
                dr.type = type_e.type_conflict;
                dr.m_start[0] = hunk[0].m_start[0];
                dr.m_length[0] = hunk[0].m_length[0];
                dr.m_start[1] = modified_start - 1;
                dr.m_length[1] = lcs_x.position[0].offset - modified_start;
                dr.m_start[2] = latest_start - 1;
                dr.m_length[2] = lcs_x.position[1].offset - latest_start;
                if (hunk[0].resolved_diff == null) {
                    hunk[0].resolved_diff = dr;
                    diff_ref = dr;
                } else {
                    diff_ref.next = dr;
                    diff_ref = dr;
                }
            }
            if (lcs_x.length == 0) break;
            modified_start = lcs_x.position[0].offset;
            latest_start = lcs_x.position[1].offset;
            svn_diff_t dn = new svn_diff_t();
            dn.type = type_e.type_common;
            dn.m_start[0] = hunk[0].m_start[0];
            dn.m_length[0] = hunk[0].m_length[0];
            dn.m_start[1] = modified_start - 1;
            dn.m_length[1] = lcs_x.length;
            dn.m_start[2] = latest_start - 1;
            dn.m_length[2] = lcs_x.length;
            if (hunk[0].resolved_diff == null) {
                hunk[0].resolved_diff = dn;
                diff_ref = dn;
            } else {
                diff_ref.next = dn;
                diff_ref = dn;
            }
            modified_start += lcs_x.length;
            latest_start += lcs_x.length;
            lcs_x = lcs_x.next;
        }
    }

    static final class svn_diff_fns_t {
        private file_baton_t _baton;

        public svn_diff_fns_t(file_baton_t baton) {
            this._baton = baton;
        }

        public void datasource_open(svn_diff_datasource_e datasource) {
            int idx = datasource.getValue();
            Charset[] refenc = new Charset[1];
            String[] refeol = new String[1];
            boolean[] refHasTrailingNewline = new boolean[1];
            refenc[0] = this._baton.enc[idx];
            String[] fileLines = file_baton_t.GetLines(this._baton.path[idx], idx, refenc, refeol, refHasTrailingNewline);
            if (this._baton.enc[idx] == null) {
                this._baton.enc[idx] = refenc[0];
            }
            if (this._baton.eol[idx] == null) {
                this._baton.eol[idx] = refeol[0];
            }
            this._baton.hasTrailingNewline[idx] = refHasTrailingNewline[0];
            if (fileLines.length == 0) {
                this._baton.buffer[idx] = null;
                this._baton.curp[idx] = 0;
                this._baton.endp[idx] = 0;
            } else {
                this._baton.buffer[idx] = fileLines;
                this._baton.curp[idx] = 0;
                this._baton.endp[idx] = this._baton.buffer[idx].length;
            }
        }

        public void file_token_discard(Object token) {
            this._baton.reuse_token = this._baton.token.equals(token);
        }

        public void file_token_discard_all() {
            this._baton = null;
        }

        public void datasource_get_next_token(file_token_t[] token, svn_diff_datasource_e datasource) {
            String line;
            file_token_t file_token;
            int endp;
            token[0] = null;
            int idx = datasource.getValue();
            int curp = this._baton.curp[idx];
            if (curp == (endp = this._baton.endp[idx])) {
                return;
            }
            if (!this._baton.reuse_token) {
                this._baton.token = file_token = new file_token_t();
            } else {
                file_token = this._baton.token;
                this._baton.reuse_token = false;
            }
            file_token.length = 0;
            file_token.line = line = this._baton.buffer[idx][curp].replaceAll("(\r|\n)+$", "");
            file_token.length = line.length();
            int n = idx;
            this._baton.curp[n] = this._baton.curp[n] + 1;
            token[0] = file_token;
            file_token.line = line;
        }

        public int token_compare(Object token1, Object token2) {
            file_token_t file_token1 = (file_token_t)token1;
            file_token_t file_token2 = (file_token_t)token2;
            if (file_token1.length < file_token2.length) {
                return -1;
            }
            if (file_token1.length > file_token2.length) {
                return 1;
            }
            return file_token1.compareTo(file_token2);
        }

        public Charset ComputeBestEncoding() {
            return this._baton.ComputeBestEncoding();
        }

        public String ComputeBestLineEnding() {
            return this._baton.ComputeBestLineEnding();
        }

        public boolean ComputeBestTrailingEol() {
            return this._baton.ComputeBestTrailingEol();
        }
    }

    static final class file_baton_t {
        public String[] path = new String[4];
        public String[][] buffer = new String[4][];
        public int[] curp = new int[4];
        public int[] endp = new int[4];
        public file_token_t token;
        public boolean reuse_token;
        public int options;
        public String[] eol = new String[4];
        public Charset[] enc = new Charset[4];
        public boolean[] hasTrailingNewline = new boolean[]{true, true, true, true};

        file_baton_t() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String[] GetLines(String filename, int fileTag, Charset[] enc, String[] eol, boolean[] hasTrailingEol) {
            String[] stringArray;
            InputStreamReader isr;
            int windows = 0;
            int unix = 0;
            int mac = 0;
            FileInputStream fis = new FileInputStream(filename);
            if (enc[0] != null) {
                CharsetDecoder decoder = enc[0].newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                isr = new InputStreamReader((InputStream)fis, decoder);
            } else {
                isr = new InputStreamReader(fis);
            }
            BufferedReader sr = new BufferedReader(isr);
            hasTrailingEol[0] = true;
            try {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                String[] newline = new String[1];
                while ((line = file_baton_t.readline(sr, newline)) != null) {
                    lines.add(line);
                    if (newline[0] == null) {
                        hasTrailingEol[0] = false;
                        continue;
                    }
                    if (newline[0].equals("\r\n")) {
                        ++windows;
                        continue;
                    }
                    if (newline[0].equals("\n")) {
                        ++unix;
                        continue;
                    }
                    if (!newline[0].equals("\r")) continue;
                    ++mac;
                }
                try {
                    enc[0] = Charset.forName(isr.getEncoding());
                }
                catch (Throwable e) {
                    enc[0] = file_baton_t.getDefaultCharset();
                }
                eol[0] = windows > unix && windows > mac ? "\r\n" : (unix > windows && unix > mac ? "\n" : (mac > windows && mac > unix ? "\r" : System.getProperty("line.separator")));
                stringArray = lines.toArray(new String[lines.size()]);
            }
            catch (Throwable throwable) {
                try {
                    sr.close();
                    throw throwable;
                }
                catch (MalformedInputException e) {
                    log.info((Object)("The file " + filename + " could not be read with the encoding " + file_baton_t.getEncodingName(enc[0])), (Throwable)e);
                    throw new VersionControlException(MessageFormat.format(FileEncoding.ENCODING_ERROR_MESSAGE_FORMAT, file_baton_t.getFileTagName(fileTag), LocalPath.getFileName(filename), file_baton_t.getEncodingName(enc[0])), e);
                }
                catch (UnmappableCharacterException e) {
                    log.info((Object)("The file " + filename + " could not be read with the encoding " + file_baton_t.getEncodingName(enc[0])), (Throwable)e);
                    throw new VersionControlException(MessageFormat.format(FileEncoding.ENCODING_ERROR_MESSAGE_FORMAT, file_baton_t.getFileTagName(fileTag), LocalPath.getFileName(filename), file_baton_t.getEncodingName(enc[0])), e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read file " + filename, e);
                }
            }
            sr.close();
            return stringArray;
        }

        private static String getEncodingName(Charset charset) {
            return charset != null ? charset.displayName() : file_baton_t.getDefaultCharset().displayName();
        }

        private static String getFileTagName(int fileTag) {
            switch (fileTag) {
                case 0: {
                    return Messages.getString("libsgdcore.lite.OriginalFile");
                }
                case 1: {
                    return Messages.getString("libsgdcore.lite.ModifiedFile");
                }
                case 2: {
                    return Messages.getString("libsgdcore.lite.LatestFile");
                }
            }
            return "";
        }

        private static String readline(BufferedReader reader, String[] newline) throws IOException {
            char[] cbuf = new char[1];
            StringBuffer line = new StringBuffer();
            int readlen = 0;
            newline[0] = null;
            boolean lastCR = false;
            while (reader.read(cbuf, 0, 1) > 0) {
                ++readlen;
                if (cbuf[0] == '\n' && lastCR) {
                    newline[0] = "\r\n";
                    break;
                }
                if (lastCR) {
                    newline[0] = "\r";
                    reader.reset();
                    break;
                }
                if (cbuf[0] == '\n') {
                    newline[0] = "\n";
                    break;
                }
                if (cbuf[0] == '\r') {
                    reader.mark(1);
                    lastCR = true;
                    continue;
                }
                lastCR = false;
                line.append(cbuf[0]);
            }
            if (readlen == 0) {
                return null;
            }
            return line.toString();
        }

        public Charset ComputeBestEncoding() {
            if (this.enc[0] != null && this.enc[1] != null && !this.enc[0].equals(this.enc[1])) {
                return this.enc[1];
            }
            if (this.enc[0] != null && this.enc[2] != null && !this.enc[0].equals(this.enc[2])) {
                return this.enc[2];
            }
            if (this.enc[0] != null) {
                return this.enc[0];
            }
            return file_baton_t.getDefaultCharset();
        }

        private static Charset getDefaultCharset() {
            try {
                String defaultEncoding = System.getProperty("file.encoding");
                if (defaultEncoding != null && Charset.forName(defaultEncoding) != null) {
                    return Charset.forName(defaultEncoding);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                return Charset.forName("UTF-8");
            }
            catch (Exception e) {
                return null;
            }
        }

        public String ComputeBestLineEnding() {
            if (this.eol[0] != null && this.eol[1] != null && !this.eol[0].equals(this.eol[1])) {
                return this.eol[1];
            }
            if (this.eol[0] != null && this.eol[2] != null && !this.eol[0].equals(this.eol[2])) {
                return this.eol[2];
            }
            if (this.eol[0] != null) {
                return this.eol[0];
            }
            return System.getProperty("line.separator");
        }

        public boolean ComputeBestTrailingEol() {
            if (this.hasTrailingNewline[0] != this.hasTrailingNewline[1]) {
                return this.hasTrailingNewline[1];
            }
            if (this.hasTrailingNewline[0] != this.hasTrailingNewline[2]) {
                return this.hasTrailingNewline[2];
            }
            return this.hasTrailingNewline[0];
        }
    }

    static final class output_fns_t {
        private final file_output_baton_t _baton;

        public output_fns_t(file_output_baton_t baton) {
            this._baton = baton;
        }

        public void output_common(int original_start, int original_length, int modified_start, int modified_length, int latest_start, int latest_length, boolean lastDiff) {
            this.file_output_hunk(0, original_start, original_length, lastDiff);
        }

        public void output_diff_modified(int original_start, int original_length, int modified_start, int modified_length, int latest_start, int latest_length, boolean lastDiff) {
            this.file_output_hunk(1, modified_start, modified_length, lastDiff);
        }

        public void output_diff_latest(int original_start, int original_length, int modified_start, int modified_length, int latest_start, int latest_length, boolean lastDiff) {
            this.file_output_hunk(2, latest_start, latest_length, lastDiff);
        }

        public void output_diff_common(int original_start, int original_length, int modified_start, int modified_length, int latest_start, int latest_length, boolean lastDiff) {
            this.file_output_hunk(1, modified_start, modified_length, lastDiff);
        }

        public void output_conflict(int original_start, int original_length, int modified_start, int modified_length, int latest_start, int latest_length, svn_diff_t resolved_diff, boolean lastDiff) {
            if (resolved_diff != null && this._baton.display_resolved_conflicts) {
                libsgdcore_lite.svn_diff_output(resolved_diff, this);
            }
            try {
                this._baton.output_file.write(this._baton.conflict_modified);
                this._baton.output_file.write(this._baton.getEOL());
            }
            catch (Exception ex) {
                throw new RuntimeException("error writing file", ex);
            }
            this.file_output_hunk(1, modified_start, modified_length, false);
            if (this._baton.display_original_in_conflict) {
                try {
                    this._baton.output_file.write(this._baton.conflict_original);
                    this._baton.output_file.write(this._baton.getEOL());
                }
                catch (Exception ex) {
                    throw new RuntimeException("error writing file", ex);
                }
                this.file_output_hunk(0, original_start, original_length, false);
            }
            try {
                this._baton.output_file.write(this._baton.conflict_separator);
                this._baton.output_file.write(this._baton.getEOL());
            }
            catch (Exception ex) {
                throw new RuntimeException("error writing file", ex);
            }
            this.file_output_hunk(2, latest_start, latest_length, false);
            try {
                this._baton.output_file.write(this._baton.conflict_latest);
                this._baton.output_file.write(this._baton.getEOL());
            }
            catch (Exception ex) {
                throw new RuntimeException("error writing file", ex);
            }
        }

        void file_output_line(file_output_type_e type, int idx, boolean lastLine) {
            int curp = this._baton.curp[idx];
            int endp = this._baton.endp[idx];
            int current_line = this._baton.current_line[idx];
            try {
                int n = idx;
                this._baton.current_line[n] = this._baton.current_line[n] + 1;
                if (curp == endp) {
                    return;
                }
                if (type != file_output_type_e.file_output_skip) {
                    String s = this._baton.buffer[idx][current_line];
                    this._baton.output_file.write(s);
                    if (!lastLine || this._baton.getTrailingEol()) {
                        this._baton.output_file.write(this._baton.getEOL());
                    }
                }
                int n2 = idx;
                this._baton.curp[n2] = this._baton.curp[n2] + 1;
            }
            catch (Exception ex) {
                throw new RuntimeException("error writing file", ex);
            }
        }

        private void file_output_hunk(int idx, int target_line, int target_length, boolean lastDiff) {
            while (this._baton.current_line[idx] < target_line) {
                this.file_output_line(file_output_type_e.file_output_skip, idx, false);
            }
            target_line += target_length;
            while (this._baton.current_line[idx] < target_line) {
                boolean lastLine = lastDiff && this._baton.current_line[idx] + 1 == target_line;
                this.file_output_line(file_output_type_e.file_output_normal, idx, lastLine);
            }
        }
    }

    public static final class svn_diff_t {
        public svn_diff_t next;
        public type_e type;
        public int[] m_start = new int[3];
        public int[] m_length = new int[3];
        public svn_diff_t resolved_diff;
    }

    static final class svn_diff_datasource_e
    extends TypesafeEnum {
        public static final svn_diff_datasource_e svn_diff_datasource_original = new svn_diff_datasource_e(0);
        public static final svn_diff_datasource_e svn_diff_datasource_modified = new svn_diff_datasource_e(1);
        public static final svn_diff_datasource_e svn_diff_datasource_latest = new svn_diff_datasource_e(2);
        public static final svn_diff_datasource_e svn_diff_datasource_ancestor = new svn_diff_datasource_e(3);

        private svn_diff_datasource_e(int source) {
            super(source);
        }
    }

    public static final class type_e
    extends TypesafeEnum {
        public static final type_e type_common = new type_e(0);
        public static final type_e type_diff_modified = new type_e(1);
        public static final type_e type_diff_latest = new type_e(2);
        public static final type_e type_diff_common = new type_e(3);
        public static final type_e type_conflict = new type_e(4);
        public static final type_e __nr_types__ = new type_e(5);

        private type_e(int type) {
            super(type);
        }
    }

    static final class SGD_MergeResult
    extends TypesafeEnum {
        public static final SGD_MergeResult SGD_MergeResult_Identical = new SGD_MergeResult(0);
        public static final SGD_MergeResult SGD_MergeResult_Differences = new SGD_MergeResult(1);
        public static final SGD_MergeResult SGD_MergeResult_Conflicts = new SGD_MergeResult(2);
        public static final SGD_MergeResult SGD_MergeResult_Error = new SGD_MergeResult(3);

        private SGD_MergeResult(int result) {
            super(result);
        }
    }

    static final class file_token_t
    implements Comparable {
        public int length;
        public String line;

        file_token_t() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof file_token_t)) {
                return false;
            }
            return this.line.equals(((file_token_t)obj).line);
        }

        public int compareTo(Object obj) {
            return this.line.compareTo(((file_token_t)obj).line);
        }
    }

    static final class snake_t {
        public int y;
        public lcs_t lcs;
        public position_t[] position = new position_t[2];

        snake_t() {
        }
    }

    static final class lcs_t {
        public lcs_t next;
        public position_t[] position = new position_t[2];
        public int length;

        lcs_t() {
        }
    }

    static final class position_t {
        public position_t next;
        public position_t prev;
        public node_t node;
        public int offset;
        public int maxoffset;

        position_t() {
        }
    }

    static final class tree_t {
        public node_t root;

        tree_t() {
        }
    }

    static final class node_t
    implements Comparable {
        public node_t parent;
        public node_t left;
        public node_t right;
        public file_token_t token;

        node_t() {
        }

        public int compareTo(Object obj) {
            return this.token.compareTo(((node_t)obj).token);
        }
    }

    static final class file_output_baton_t {
        public Writer output_file;
        public String[] path = new String[3];
        public int[] current_line = new int[3];
        private String _eol = System.getProperty("line.separator");
        private boolean trailingEol = true;
        public String[][] buffer = new String[3][];
        public int[] endp = new int[3];
        public int[] curp = new int[3];
        public String conflict_modified;
        public String conflict_original;
        public String conflict_separator;
        public String conflict_latest;
        public boolean display_original_in_conflict;
        public boolean display_resolved_conflicts;

        file_output_baton_t() {
        }

        public String getEOL() {
            return this._eol;
        }

        public void setEOL(String eol) {
            this._eol = eol;
        }

        public boolean getTrailingEol() {
            return this.trailingEol;
        }

        public void setTrailingEol(boolean trailingEol) {
            this.trailingEol = trailingEol;
        }
    }

    static final class file_output_type_e
    extends TypesafeEnum {
        public static final file_output_type_e file_output_skip = new file_output_type_e(1);
        public static final file_output_type_e file_output_normal = new file_output_type_e(2);

        private file_output_type_e(int type) {
            super(type);
        }
    }

    static final class NDX {
        public static final int NDX_UNSPECIFIED = -1;
        public static final int NDX_ORIGINAL = 0;
        public static final int NDX_MODIFIED = 1;
        public static final int NDX_LATEST = 2;

        NDX() {
        }
    }
}

