/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.fileformat;

public class AppleForkedConstants {
    public static final int MAGIC_APPLESINGLE = 333312;
    public static final int MAGIC_APPLEDOUBLE = 333319;
    public static final int VERSION_1 = 65536;
    public static final int VERSION_2 = 131072;
    public static final byte[] FILESYSTEM = new byte[]{77, 97, 99, 105, 110, 116, 111, 115, 104, 32, 32, 32, 32, 32, 32, 32};
    public static final long MAX_OFFSET = 0xFFFFFFFFL;
    public static final long MAX_LENGTH = 0xFFFFFFFFL;
    public static final int ID_DATAFORK = 1;
    public static final int ID_RESOURCEFORK = 2;
    public static final int ID_FILENAME = 3;
    public static final int ID_COMMENT = 4;
    public static final int ID_ICON_BW = 5;
    public static final int ID_ICON_COLOR = 6;
    public static final int ID_FILEINFO = 7;
    public static final int ID_DATEINFO = 8;
    public static final int ID_FINDERINFO = 9;
    public static final int ID_MACFILEINFO = 10;
    public static final int ID_PRODOSFILEINFO = 11;
    public static final int ID_MSDOSFILEINFO = 12;
    public static final int ID_AFPSHORTNAME = 13;
    public static final int ID_AFPFILEINFO = 14;
    public static final int ID_AFPDIRECTORYID = 15;
    public static final String XATTR_FINDERINFO = "com.apple.FinderInfo";
    public static final String XATTR_COMMENT = "com.apple.metadata:kMDItemFinderComment";

    public static String getNameFromMagic(int magic) {
        if (magic == 333312) {
            return "AppleSingle";
        }
        if (magic == 333319) {
            return "AppleDouble";
        }
        return "Apple 0x" + Integer.toHexString(magic);
    }
}

