/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.index.backup.AutoBackupOptionBase;
import com.teamscale.index.backup.AutoBackupTrigger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="schedule.backup", name="Automatic Backup", type=EOptionType.SERVER, category=EOptionCategory.BACKUP)
@IndexValueClass(containedInBackup=true)
public class AutoBackupOption
extends AutoBackupOptionBase {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "schedule.backup";
    public static final String OPTION_NAME = "Automatic Backup";
    @JsonProperty(value="storageLocation")
    @OptionFieldDescription(name="Backup File Path", description="Full path or URL to store the backup ZIP into. '%t' is replaced by the current date/time stamp. '%h' is replaced by the name of the host machine. '%p' is replaced by the configured HTTPS or HTTP port. '%i' is replaced by the instance name defined in the server configuration (teamscale.properties). '%u' is replaced by the configured URL prefix.")
    public String storageLocation = this.getStorageLocationDefaultValue();
    @JsonProperty(value="updateSchedule")
    @OptionFieldDescription(name="Backup schedule")
    @ScheduleOption(triggerClass=AutoBackupTrigger.class)
    public String updateSchedule = "@daily";
    @JsonProperty(value="daysToKeepAllBackups")
    @OptionFieldDescription(name="Preserve all backups for the given number of days in the past. Set to 0 to disable.")
    public int daysToKeepAllBackups = 7;
    @JsonProperty(value="weeksToKeepWeeklyBackups")
    @OptionFieldDescription(name="Preserve the last backup of each week within the given number of weeks in the past. A week starts on Sunday. Set to 0 to disable.")
    public int weeksToKeepWeeklyBackups = 4;
    @JsonProperty(value="monthsToKeepMonthlyBackups")
    @OptionFieldDescription(name="Preserve the last backup of each month within the given number of months in the past. Set to 0 to disable.")
    public int monthsToKeepMonthlyBackups = 3;

    public boolean isBackupCleanupActive() {
        return this.daysToKeepAllBackups > 0 || this.weeksToKeepWeeklyBackups > 0 || this.monthsToKeepMonthlyBackups > 0;
    }

    @Override
    protected String determineDefaultFilenamePrefix() {
        return "teamscale-backup";
    }

    @Override
    protected String getStorageLocation() {
        return this.storageLocation;
    }

    public @Nullable String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (this.daysToKeepAllBackups < 0) {
            return "Days to keep all backups can't be negative.";
        }
        if (this.weeksToKeepWeeklyBackups < 0) {
            return "Weeks to keep weekly backups can't be negative.";
        }
        if (this.monthsToKeepMonthlyBackups < 0) {
            return "Months to keep monthly backups can't be negative.";
        }
        String backupLocationError = AutoBackupOption.validateStorageLocationIsZipPath(this.storageLocation);
        if (backupLocationError != null) {
            return backupLocationError;
        }
        if (!this.isBackupCleanupActive()) {
            return null;
        }
        backupLocationError = this.validateStorageLocationContainsPlaceholders(this.storageLocation, storageInfo.getGlobalStorageSystem(), instanceConfiguration);
        if (backupLocationError != null) {
            return backupLocationError;
        }
        if (StringUtils.isEmpty((String)this.updateSchedule)) {
            return "Backup schedule must be set if backup folder cleanup is active.";
        }
        return null;
    }
}

