/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.http.HttpBackupTarget;
import com.teamscale.index.backup.instance.InstanceBackupTarget;
import com.teamscale.index.backup.local.LocalFileBackupTarget;
import com.teamscale.index.backup.s3.S3BackupTarget;
import com.teamscale.index.backup.tempfile.TemporaryFileIndexBackupTarget;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class BackupTargetFactory {
    public static IBackupTarget getReadTarget(String uriOrPath, ExternalCredentialsIndex externalCredentialsIndex, TemporaryFileIndex fileIndex, Logger interactionLogger) throws StorageException {
        return BackupTargetFactory.getTarget(uriOrPath, externalCredentialsIndex, fileIndex, null, false, interactionLogger);
    }

    public static IBackupTarget getReadTarget(String uriOrPath, ExternalCredentialsIndex externalCredentialsIndex, TemporaryFileIndex fileIndex, InstanceCredentials credentials, Logger interactionLogger) throws StorageException {
        return BackupTargetFactory.getTarget(uriOrPath, externalCredentialsIndex, fileIndex, credentials, false, interactionLogger);
    }

    public static IBackupTarget getWriteTarget(String uriOrPath, ExternalCredentialsIndex externalCredentialsIndex, TemporaryFileIndex fileIndex, Logger interactionLogger) throws StorageException {
        return BackupTargetFactory.getTarget(uriOrPath, externalCredentialsIndex, fileIndex, null, true, interactionLogger);
    }

    private static IBackupTarget getTarget(String uriOrPath, ExternalCredentialsIndex externalCredentialsIndex, TemporaryFileIndex fileIndex, InstanceCredentials instanceCredentials, boolean writeTarget, Logger interactionLogger) throws StorageException {
        Optional<URI> uri = BackupTargetFactory.createUriIfValid(uriOrPath);
        if (uri.isPresent()) {
            String scheme = uri.get().getScheme();
            if ("file".equalsIgnoreCase(scheme)) {
                return BackupTargetFactory.getLocalFileBackupTargetForPath(uri.get().getPath(), writeTarget);
            }
            if ("s3+http".equalsIgnoreCase(scheme) || "s3+https".equalsIgnoreCase(scheme) || "s3".equalsIgnoreCase(scheme) || "gs".equalsIgnoreCase(scheme)) {
                return new S3BackupTarget(uri.get(), externalCredentialsIndex);
            }
            if ("ts+http".equalsIgnoreCase(scheme) || "ts+https".equalsIgnoreCase(scheme)) {
                return new InstanceBackupTarget(uri.get(), instanceCredentials, interactionLogger);
            }
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                return new HttpBackupTarget(uri.get());
            }
            if ("index".equalsIgnoreCase(scheme)) {
                return new TemporaryFileIndexBackupTarget(uri.get(), fileIndex);
            }
        }
        return BackupTargetFactory.getLocalFileBackupTargetForPath(uriOrPath, writeTarget);
    }

    private static Optional<URI> createUriIfValid(String uriOrPath) {
        try {
            URI uri = URI.create(BackupTargetFactory.normalizeSeparators(uriOrPath));
            return Optional.of(uri);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static IBackupTarget getLocalFileBackupTargetForPath(String path, boolean writeTarget) throws StorageException {
        try {
            return new LocalFileBackupTarget(path, writeTarget);
        }
        catch (IOException e) {
            throw new StorageException(e.getMessage(), (Throwable)e);
        }
    }

    public static String normalizeSeparators(String uriString) {
        return uriString.replace('\\', '/');
    }
}

