/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.code_ownership.CodeOwnershipIndex;
import com.teamscale.index.code_ownership.CodeOwnershipSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;

public class TeamAnalysisConfiguration
extends AnalysisConfigurationBase {
    @ConfigExposed(name="Enable Code Ownership Analysis", description="Enables code ownership analysis needed for the Code Ownership Treemap.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private boolean ownerShipAnalysisEnabled = false;

    TeamAnalysisConfiguration() {
        this.autoExpose();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOption(this.getOptionForField("ownerShipAnalysisEnabled"));
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.configureOwnershipAnalysis(proxy);
    }

    private void configureOwnershipAnalysis(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (this.ownerShipAnalysisEnabled) {
            proxy.createProjectIndex(CodeOwnershipIndex.class);
            proxy.createTrigger(new TriggerBuilder(CodeOwnershipSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        }
    }

    public boolean isCoreConfiguration() {
        return true;
    }
}

