/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.configuration.tools.AnalysisToolsConfigurationUtils;
import com.teamscale.index.findings.swiftlint.SwiftLintRunner;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SwiftLintConfiguration
extends ToolConfigurationBase {
    private static final String RESOURCE_BASE_PATH = "message/swiftlint/";
    public static final String SWIFTLINT_MAPPINGS_TSV = "message/swiftlint/check-mappings.tsv";
    public static final String SWIFTLINT_OPTIONS_TSV = "message/swiftlint/check-options.tsv";
    private static final String DESCRIPTIONS_PATH = "swiftlint";

    public SwiftLintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.SWIFT_LINT, DESCRIPTIONS_PATH, DESCRIPTIONS_PATH, SWIFTLINT_MAPPINGS_TSV, SWIFTLINT_OPTIONS_TSV, "");
        this.declareCodeScopeAware();
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        super.registerQualityIndicators(template, languages, tools);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware activeChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (activeChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(SwiftLintRunner.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setTriggerParameter("checks", ITriggerParameter.of((Object)activeChecksPerCodeScope));
        this.configureOptions((CodeScopeAware<Collection<String>>)activeChecksPerCodeScope, triggerBuilder);
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    private void configureOptions(CodeScopeAware<Collection<String>> activeChecksPerCodeScope, TriggerBuilder triggerBuilder) {
        CodeScopeAware selectedOptionsPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware optionValuesPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware optionTypesPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : activeChecksPerCodeScope.getCodeScopeNames()) {
            selectedOptionsPerCodeScope.setValue(codeScopeName, new ArrayList());
            optionValuesPerCodeScope.setValue(codeScopeName, new ArrayList());
            optionTypesPerCodeScope.setValue(codeScopeName, new ArrayList());
            if (((Collection)activeChecksPerCodeScope.getValue(codeScopeName)).isEmpty()) continue;
            HashSet<String> selectedChecks = new HashSet<String>((Collection)activeChecksPerCodeScope.getValue(codeScopeName));
            for (ConfigOptionDescriptorBase option : this.getVisibleOptions()) {
                if (!SwiftLintConfiguration.checkIsActive(selectedChecks, option)) continue;
                SwiftLintConfiguration.configureOption(option, (Collection)selectedOptionsPerCodeScope.getValue(codeScopeName), (Collection)optionValuesPerCodeScope.getValue(codeScopeName), (Collection)optionTypesPerCodeScope.getValue(codeScopeName), codeScopeName);
            }
        }
        triggerBuilder.setTriggerParameter("check-options", ITriggerParameter.of((Object)selectedOptionsPerCodeScope));
        triggerBuilder.setTriggerParameter("check-option-values", ITriggerParameter.of((Object)optionValuesPerCodeScope));
        triggerBuilder.setTriggerParameter("check-option-types", ITriggerParameter.of((Object)optionTypesPerCodeScope));
    }

    private static void configureOption(ConfigOptionDescriptorBase option, Collection<String> selectedOptions, Collection<String> optionValues, Collection<String> optionTypes, CodeScopeName codeScope) {
        selectedOptions.add(option.getName());
        if (option.getName().contains("yaml_config")) {
            optionValues.add(StringUtils.replaceLineBreaks((String)option.retrieveValueAsString(codeScope), (String)"\t"));
        } else {
            optionValues.add(option.retrieveValueAsString(codeScope));
        }
        optionTypes.add(option.getType());
    }

    private static boolean checkIsActive(Set<String> activeChecks, ConfigOptionDescriptorBase option) {
        String checkID = StringUtils.getFirstPart((String)option.getName(), (String)".");
        return activeChecks.contains(checkID);
    }

    public void validateTools() throws ProjectConfigurationException {
        SwiftLintConfiguration.checkSwiftLintAvailable();
    }

    private static void checkSwiftLintAvailable() throws ProjectConfigurationException {
        Predicate<ProcessUtils.ExecutionResult> availabilityPredicate = result -> result.getReturnCode() == 0;
        AnalysisToolsConfigurationUtils.checkProgramAvailability(DESCRIPTIONS_PATH, null, availabilityPredicate, false, true);
    }
}

