/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap;

import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.abap.AbapPatterns;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AbapConditionHeuristic
extends ConditionHeuristicBase {
    private static final EnumSet<ETokenType> NOT_AS_KEYWORD_TOKENS = EnumSet.of(ETokenType.BOUND, ETokenType.ASSIGNED, ETokenType.INITIAL);
    private static final TokenPattern NULL_CHECK_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_PATTERN}).group(0).sequence(new Object[]{ETokenType.IS, ETokenType.NOT, ETokenType.ASSIGNED}), new TokenPattern().sequence(new Object[]{ETokenType.NOT}).sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_PATTERN}).group(0).sequence(new Object[]{ETokenType.IS, ETokenType.ASSIGNED}), new TokenPattern().sequence(new Object[]{AbapPatterns.FIELD_SYMBOL_PATTERN}).group(1).sequence(new Object[]{ETokenType.IS, ETokenType.ASSIGNED}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.IS, ETokenType.NOT, ETokenType.BOUND}), new TokenPattern().sequence(new Object[]{ETokenType.NOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.IS, ETokenType.BOUND}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IS, ETokenType.BOUND}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IS, ETokenType.NOT, ETokenType.INITIAL}), new TokenPattern().sequence(new Object[]{ETokenType.NOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IS, ETokenType.INITIAL}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.IS, ETokenType.INITIAL})});
    private static final Map<ETokenType, ConditionTreeNode.EOperator> OPERATOR_TOKENS = new EnumMap<ETokenType, ConditionTreeNode.EOperator>(ETokenType.class);

    public AbapConditionHeuristic(IDefUseHeuristic defUseHeuristic) {
        super(defUseHeuristic, NULL_CHECK_PATTERN, null, OPERATOR_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    @Override
    protected boolean shouldTreatAsOperator(List<IToken> tokens, int position) {
        if (position == 0 || position == tokens.size() - 1) {
            return true;
        }
        if (tokens.get(position - 1).getType() != ETokenType.IS) {
            return true;
        }
        return !NOT_AS_KEYWORD_TOKENS.contains(tokens.get(position + 1).getType());
    }

    @Override
    protected List<IToken> filter(List<IToken> tokens) {
        int start = 0;
        if (tokens.size() > 0 && tokens.get(0).getType().getTokenClass() == ETokenType.ETokenClass.KEYWORD) {
            start = 1;
        }
        int end = tokens.size();
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        if (lastToken != null && lastToken.getType() == ETokenType.DOT) {
            --end;
        }
        return tokens.subList(start, end);
    }

    static {
        OPERATOR_TOKENS.put(ETokenType.AND, ConditionTreeNode.EOperator.AND);
        OPERATOR_TOKENS.put(ETokenType.OR, ConditionTreeNode.EOperator.OR);
        OPERATOR_TOKENS.put(ETokenType.NOT, ConditionTreeNode.EOperator.NOT);
    }
}

