/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex;

import com.google.common.collect.MoreCollectors;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphSerializationUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

public abstract class MethodTaintGraphIndexBase<T extends MethodTaintGraph>
extends IndexBase
implements IProjectIndex {
    protected MethodTaintGraphIndexBase(IStore store) {
        super(store);
    }

    public Map<String, T> getMethodTaintGraphs(String uniformPath) throws StorageException {
        return MethodTaintGraphIndexBase.deserializeToMap(this.store.getWithString(uniformPath));
    }

    protected static <T extends MethodTaintGraph> Map<String, T> deserializeToMap(byte[] value) {
        if (value == null) {
            return new HashMap();
        }
        ArrayList graphs = MethodTaintGraphSerializationUtils.deserialize(value);
        return graphs.stream().collect(Collectors.groupingBy(MethodTaintGraph::getMethodIdentifier, HashMap::new, MoreCollectors.onlyElement()));
    }

    public Map<String, T> getAllMethodTaintGraphs() throws StorageException {
        ConcurrentHashMap result = new ConcurrentHashMap();
        this.store.scan(new byte[0], (key, value) -> {
            ArrayList<MethodTaintGraph> graphs = MethodTaintGraphSerializationUtils.deserialize(value);
            for (MethodTaintGraph graph : graphs) {
                result.put(graph.getMethodIdentifier(), graph);
            }
        });
        return result;
    }

    public void setMethodTaintGraphs(String uniformPath, Collection<T> graphs) throws StorageException {
        this.store.putWithString(uniformPath, this.sortAndSerialize(graphs));
    }

    protected byte[] sortAndSerialize(Collection<T> graphs) {
        ArrayList<T> sortedGraphs = new ArrayList<T>(graphs);
        sortedGraphs.sort(Comparator.comparing(MethodTaintGraph::getMethodIdentifier));
        return MethodTaintGraphSerializationUtils.serialize(sortedGraphs);
    }

    public void removeForUniformPaths(List<String> uniformPaths) throws StorageException {
        this.store.removeWithStrings(uniformPaths);
    }

    public List<String> getAllKeys() throws StorageException {
        return StorageUtils.listStringKeys((IStore)this.store);
    }

    public byte[] getRawValue(String key) throws StorageException {
        return this.store.getWithString(key);
    }

    public byte[] getRawSerializedDataForUniformPath(String uniformPath) throws StorageException {
        return this.store.getWithString(uniformPath);
    }
}

