/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.external.input.SimulinkFindingLocationAdjuster;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class FindingLocationAdjuster {
    private final SimulinkFindingLocationAdjuster simulinkFindingLocationAdjuster;

    public FindingLocationAdjuster(SimulinkModelInfoIndex simulinkFindingLocationAdjuster) {
        this.simulinkFindingLocationAdjuster = new SimulinkFindingLocationAdjuster(simulinkFindingLocationAdjuster);
    }

    public ExternalAnalysisImportInfo.IFindingAdjuster createFindingsAdjuster(String importedContent, LocationAdjuster adjuster) {
        return findings -> {
            List<DetachedFinding> adjustedFindings = IndexFindingUtils.adjustFindingLocations((LocationAdjuster)adjuster, FindingLocationAdjuster.fillInMissingOffsets(findings, importedContent), DetachedFinding::new);
            adjustedFindings = this.simulinkFindingLocationAdjuster.correctSimulinkLocations(adjustedFindings);
            return FindingLocationAdjuster.removeFindingTimestamps(adjustedFindings);
        };
    }

    private static List<IndexFinding> removeFindingTimestamps(List<DetachedFinding> adjustedFindings) {
        return CollectionUtils.map(adjustedFindings, finding -> new IndexFinding(finding, 0L));
    }

    private static List<DetachedFinding> fillInMissingOffsets(List<DetachedFinding> findings, String content) {
        LineOffsetConverter converter = null;
        for (DetachedFinding finding : findings) {
            TextRegionLocation location;
            if (!(finding.getLocation() instanceof TextRegionLocation) || IndexFindingUtils.hasValidOffsets((TextRegionLocation)(location = (TextRegionLocation)finding.getLocation()))) continue;
            if (converter == null) {
                converter = new LineOffsetConverter(content);
            }
            if (!converter.isValidLine(location.getRawStartLine()) || !converter.isValidLine(location.getRawEndLine())) {
                finding.setLocation(new ElementLocation(location.getUniformPath()));
                continue;
            }
            finding.setLocation((ElementLocation)IndexFindingUtils.fillInMissingOffsets((TextRegionLocation)location, (LineOffsetConverter)converter, (String)content));
            FindingLocationAdjuster.convertStatementPathOffsets(finding, converter, content);
        }
        return findings;
    }

    private static void convertStatementPathOffsets(DetachedFinding finding, LineOffsetConverter converter, String content) {
        if (finding.getStatementPath().isEmpty()) {
            return;
        }
        for (StatementPathElement pathElement : finding.getStatementPath()) {
            TextRegionLocation pathElementLocation = (TextRegionLocation)pathElement.getLocation();
            pathElement.setLocation((ElementLocation)IndexFindingUtils.fillInMissingOffsets((TextRegionLocation)pathElementLocation, (LineOffsetConverter)converter, (String)content));
        }
    }
}

