/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.index.findings.kubescore.KubernetesManifestHandler;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntity;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntityContainer;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntityContainerPort;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntityMetadata;
import com.teamscale.index.findings.kubescore.entitites.KubernetesEntitySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;

public class KubernetesChecks {
    private final List<IndexFinding> findings = new ArrayList<IndexFinding>();
    private final KubernetesManifestHandler kubernetesManifestHandler;
    private final String uniformPath;

    public KubernetesChecks(KubernetesManifestHandler kubernetesManifestHandler, String uniformPath) {
        this.kubernetesManifestHandler = kubernetesManifestHandler;
        this.uniformPath = uniformPath;
    }

    public List<IndexFinding> execute() {
        PairList<String, LineBasedRegion> entitiesWithLineOffsets = this.kubernetesManifestHandler.getEntitiesWithRegions();
        for (Pair entityWithLineOffset : entitiesWithLineOffsets) {
            this.executeChecksForEntity((Pair<String, LineBasedRegion>)entityWithLineOffset, this.uniformPath);
        }
        return this.findings;
    }

    private void executeChecksForEntity(Pair<String, LineBasedRegion> entitiesWithLineOffsets, String uniformPath) {
        String entityContent = (String)entitiesWithLineOffsets.getFirst();
        KubernetesEntity entity = KubernetesUtils.readEntityContent(uniformPath, entityContent);
        if (entity == null) {
            return;
        }
        String kind = entity.getKind();
        if (kind == null) {
            return;
        }
        String type = kind.toLowerCase();
        String[] lines = entityContent.split("\n", -1);
        int currentLineOffset = ((LineBasedRegion)entitiesWithLineOffsets.getSecond()).getStart();
        this.analyzePodAndMetadata(entity, uniformPath, type, lines, currentLineOffset);
        this.executeChecks(entity, uniformPath, currentLineOffset, lines, type);
    }

    private void executeChecks(KubernetesEntity entity, String uniformPath, int currentLineOffset, String[] lines, String type) {
        switch (type) {
            case "serviceaccount": {
                this.checkAutomountServiceAccountToken(entity.getAutomountServiceAccountToken(), uniformPath, lines, currentLineOffset, 0);
                break;
            }
            case "service": {
                this.checkTypeLoadBalancer(entity, uniformPath, lines, currentLineOffset);
                break;
            }
            case "podsecuritypolicy": {
                this.checkHostPidIpcNetwork(entity, uniformPath, currentLineOffset, lines);
                break;
            }
        }
    }

    private void addFinding(String groupName, String message, ETrafficLightColor color, String uniformPath, int line) {
        TextRegionLocation location = new TextRegionLocation(uniformPath, -1, -1, line, line);
        DetachedFinding finding = new DetachedFinding(groupName, "kube-score", message, (ElementLocation)location, color);
        String originReferenceUniformPath = this.kubernetesManifestHandler.getOriginReferenceForLine(line);
        if (originReferenceUniformPath != null) {
            ElementLocation secondaryLocation = new ElementLocation(originReferenceUniformPath);
            finding.addSecondaryLocations(List.of(secondaryLocation));
        }
        this.findings.add(IndexFinding.asRealtimeFinding((DetachedFinding)finding));
    }

    private static int getLine(String[] lines, int start, Function<String, Boolean> function) {
        for (int i = start; i < lines.length; ++i) {
            if (!function.apply(lines[i]).booleanValue()) continue;
            return i;
        }
        return 0;
    }

    private void checkTypeLoadBalancer(KubernetesEntity entity, String uniformPath, String[] lines, int currentLineOffset) {
        KubernetesEntitySpec spec = entity.getSpec();
        if (spec == null) {
            return;
        }
        String type = spec.getType();
        if (type != null && type.equalsIgnoreCase("loadbalancer")) {
            int currentLineInEntity = KubernetesChecks.getLine(lines, 0, line -> line.trim().equals("spec:"));
            currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("type:"));
            this.addFinding("cqse-load-balancer", "The type LoadBalancer is used", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + currentLineInEntity);
        }
    }

    private void checkDefaultNamespace(String namespace, String uniformPath, String[] lines, int currentLineOffset, int currentLineInEntity) {
        if (namespace != null && namespace.equalsIgnoreCase("default")) {
            currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("namespace:"));
            this.addFinding("cqse-default-namespace", "The namespace is explicitly set to default", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + currentLineInEntity);
        }
    }

    private void checkNoLabels(KubernetesEntity entity, String uniformPath, String type, int findingLocation) {
        String kind = entity.getKind();
        if (kind != null && (kind.equalsIgnoreCase("replicaset") || kind.equalsIgnoreCase("replicationcontroller"))) {
            return;
        }
        KubernetesEntityMetadata metadata = entity.getMetadata();
        if (metadata == null) {
            return;
        }
        Map<String, Object> labels = metadata.getLabels();
        if (labels == null || labels.isEmpty()) {
            this.addFinding("cqse-no-labels", "No labels assigned to " + type, ETrafficLightColor.YELLOW, uniformPath, findingLocation);
        }
    }

    private void checkAutomountServiceAccountToken(String automountServiceAccountToken, String uniformPath, String[] lines, int currentLineOffset, int currentLineInEntity) {
        if (automountServiceAccountToken == null) {
            this.addFinding("cqse-automount-service-account-disabled", "The field 'automountServiceAccountToken' should be set to false", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + currentLineInEntity);
        } else if (Boolean.parseBoolean(automountServiceAccountToken)) {
            int findingLocation = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("automountServiceAccountToken:"));
            this.addFinding("cqse-automount-service-account-disabled", "The field 'automountServiceAccountToken' should be set to false", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + findingLocation);
        }
    }

    private void checkHostPort(List<KubernetesEntityContainer> containers, String uniformPath, String type, int currentLineOffset, int currentLineInEntity, String[] lines) {
        for (KubernetesEntityContainer container : containers) {
            List<KubernetesEntityContainerPort> ports = container.getPorts();
            if (ports == null) continue;
            for (KubernetesEntityContainerPort port : ports) {
                if (port.getHostPort() == null) continue;
                currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("hostPort:"));
                this.addFinding("cqse-host-port-set", "The field 'hostPort' should not be set in the container within " + type, ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + currentLineInEntity);
            }
        }
    }

    private void checkHostPidIpcNetwork(KubernetesEntity entity, String uniformPath, int currentLineOffset, String[] lines) {
        KubernetesEntitySpec spec = entity.getSpec();
        if (spec != null) {
            this.checkHostPidIpcNetwork(spec, uniformPath, lines, currentLineOffset, KubernetesChecks.getLine(lines, 0, line -> line.trim().equals("spec:")));
        }
    }

    private void checkHostPidIpcNetwork(KubernetesEntitySpec spec, String uniformPath, String[] lines, int currentLineOffset, int currentLineInEntity) {
        String hostNetwork;
        String hostIPC;
        String hostPID = spec.getHostPID();
        if (Boolean.parseBoolean(hostPID)) {
            int findingLocation = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("hostPID:"));
            this.addFinding("cqse-host-pid", "The field 'hostPID' is set to true", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + findingLocation);
        }
        if (Boolean.parseBoolean(hostIPC = spec.getHostIPC())) {
            int findingLocation = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("hostIPC:"));
            this.addFinding("cqse-host-ipc", "The field 'hostIPC' is set to true", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + findingLocation);
        }
        if (Boolean.parseBoolean(hostNetwork = spec.getHostNetwork())) {
            int findingLocation = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("hostNetwork:"));
            this.addFinding("cqse-host-network", "The field 'hostNetwork' is set to true", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + findingLocation);
        }
    }

    private void checkTerminationGracePeriodSeconds(KubernetesEntitySpec spec, String uniformPath, String[] lines, int currentLineOffset, int currentLineInEntity) {
        if (spec == null) {
            this.addFinding("cqse-termination-grace-period-seconds", "No termination grace period specified", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset);
            return;
        }
        String terminationGracePeriodSeconds = spec.getTerminationGracePeriodSeconds();
        if (terminationGracePeriodSeconds == null) {
            int lineSpec = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().equals("spec:"));
            this.addFinding("cqse-termination-grace-period-seconds", "No termination grace period specified", ETrafficLightColor.YELLOW, uniformPath, currentLineOffset + lineSpec);
        }
    }

    private void analyzePodAndMetadata(KubernetesEntity entity, String uniformPath, String type, String[] lines, int currentLineOffset) {
        int currentLineInEntity = 0;
        KubernetesEntitySpec spec = entity.getSpec();
        this.analyzeMetadata(entity, uniformPath, type, lines, currentLineOffset, currentLineInEntity);
        switch (type) {
            case "pod": {
                this.analyzePod(entity, uniformPath, type, lines, currentLineOffset, currentLineInEntity);
                break;
            }
            case "statefulset": {
                this.analyzeStatefulSet(uniformPath, type, lines, currentLineOffset, spec, currentLineInEntity);
                break;
            }
            case "daemonset": 
            case "deployment": 
            case "replicaset": 
            case "replicationcontroller": 
            case "job": {
                this.analyzeDaemonSet(uniformPath, type, lines, currentLineOffset, spec, currentLineInEntity);
                break;
            }
            case "cronjob": {
                this.analyzeCronjob(uniformPath, type, lines, currentLineOffset, spec, currentLineInEntity);
                break;
            }
        }
    }

    private void analyzeDaemonSet(String uniformPath, String type, String[] lines, int currentLineOffset, KubernetesEntitySpec spec, int currentLineInEntity) {
        if (spec == null) {
            return;
        }
        currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("spec:"));
        this.analyzeTemplate(uniformPath, type, lines, currentLineOffset, spec, currentLineInEntity);
    }

    private void analyzeStatefulSet(String uniformPath, String type, String[] lines, int currentLineOffset, KubernetesEntitySpec spec, int currentLineInEntity) {
        if (spec == null) {
            return;
        }
        currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("spec:"));
        List<KubernetesEntity> volumeClaimTemplates = spec.getVolumeClaimTemplates();
        if (volumeClaimTemplates != null) {
            int metadataLine = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("volumeClaimTemplates:"));
            for (KubernetesEntity entity : volumeClaimTemplates) {
                metadataLine = KubernetesChecks.getLine(lines, metadataLine, line -> line.trim().startsWith("-"));
                this.analyzeMetadata(entity, uniformPath, type, lines, currentLineOffset, metadataLine);
            }
        }
        this.analyzeTemplate(uniformPath, type, lines, currentLineOffset, spec, currentLineInEntity);
    }

    private void analyzeCronjob(String uniformPath, String type, String[] lines, int currentLineOffset, KubernetesEntitySpec spec, int currentLineInEntity) {
        if (spec == null) {
            return;
        }
        KubernetesEntity jobTemplate = spec.getJobTemplate();
        if (jobTemplate == null) {
            return;
        }
        currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("jobTemplate:"));
        this.analyzeMetadata(jobTemplate, uniformPath, type, lines, currentLineOffset, currentLineInEntity);
        KubernetesEntitySpec jobTemplateSpec = jobTemplate.getSpec();
        if (jobTemplateSpec != null) {
            currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("spec:"));
            this.analyzeTemplate(uniformPath, type, lines, currentLineOffset, jobTemplateSpec, currentLineInEntity);
        }
    }

    private void analyzeTemplate(String uniformPath, String type, String[] lines, int currentLineOffset, KubernetesEntitySpec spec, int currentLineInEntity) {
        KubernetesEntity template = spec.getTemplate();
        if (template == null) {
            return;
        }
        currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().startsWith("template:"));
        this.analyzeMetadata(template, uniformPath, type, lines, currentLineOffset, currentLineInEntity);
        this.analyzePod(template, uniformPath, type, lines, currentLineOffset, currentLineInEntity);
    }

    private void analyzePod(KubernetesEntity entity, String uniformPath, String type, String[] lines, int currentLineOffset, int currentLineInEntity) {
        List<KubernetesEntityContainer> initContainers;
        KubernetesEntitySpec spec = entity.getSpec();
        this.checkTerminationGracePeriodSeconds(spec, uniformPath, lines, currentLineOffset, currentLineInEntity);
        if (spec == null) {
            this.checkAutomountServiceAccountToken(entity.getAutomountServiceAccountToken(), uniformPath, lines, currentLineOffset, 0);
            return;
        }
        int lineSpec = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().equals("spec:"));
        List<KubernetesEntityContainer> containers = spec.getContainers();
        if (containers != null) {
            int lineContainers = KubernetesChecks.getLine(lines, lineSpec, line -> line.trim().equals("containers:"));
            this.checkHostPort(containers, uniformPath, type, currentLineOffset, lineContainers, lines);
        }
        if ((initContainers = spec.getInitContainers()) != null) {
            int lineInitContainers = KubernetesChecks.getLine(lines, lineSpec, line -> line.trim().equals("initContainers:"));
            this.checkHostPort(initContainers, uniformPath, type, currentLineOffset, lineInitContainers, lines);
        }
        this.checkAutomountServiceAccountToken(spec.getAutomountServiceAccountToken(), uniformPath, lines, currentLineOffset, lineSpec);
        this.checkHostPidIpcNetwork(spec, uniformPath, lines, currentLineOffset, lineSpec);
    }

    private void analyzeMetadata(KubernetesEntity entity, String uniformPath, String type, String[] lines, int currentLineOffset, int currentLineInEntity) {
        KubernetesEntityMetadata metadata = entity.getMetadata();
        if (metadata == null) {
            return;
        }
        currentLineInEntity = KubernetesChecks.getLine(lines, currentLineInEntity, line -> line.trim().equals("metadata:"));
        this.checkDefaultNamespace(metadata.getNamespace(), uniformPath, lines, currentLineOffset, currentLineInEntity);
        this.checkNoLabels(entity, uniformPath, type, currentLineOffset + currentLineInEntity);
    }
}

