/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.dto.GitHubUser;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.TeamscaleIssueSynchronizerBase;
import com.teamscale.index.issues.github.client.GitHubIssueClient;
import com.teamscale.index.issues.github.client.model.GitHubIssue;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public abstract class GitHubIssueSynchronizerBase
extends TeamscaleIssueSynchronizerBase {
    protected GitHubIssueClient gitHubClient;

    protected void determineStandardFieldTypeMappings() {
        this.addFieldTypeMapping("title", EKeyedObjectType.STRING);
        this.addFieldTypeMapping("assignee", EKeyedObjectType.STRING);
        this.addFieldTypeMapping("body", EKeyedObjectType.STRING);
        this.addFieldTypeMapping("created_at", EKeyedObjectType.DATE);
        this.addFieldTypeMapping("updated_at", EKeyedObjectType.DATE);
        this.addFieldTypeMapping("state", EKeyedObjectType.STRING);
    }

    private static String getFormattedLastScanTimestamp(long lastScanTimestamp) {
        lastScanTimestamp = Math.max(lastScanTimestamp, 0L);
        Instant lastScanInstant = Instant.ofEpochMilli(lastScanTimestamp);
        OffsetDateTime lastScanTime = OffsetDateTime.ofInstant(lastScanInstant, ZoneId.systemDefault());
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastScanTime);
    }

    private TeamscaleIssue convertIssue(GitHubIssue issue, long lowerBoundary) {
        String issueId = Long.toString(issue.number());
        String issueUrl = this.getUrl() + "/issues/" + issueId;
        String assignee = GitHubIssueSynchronizerBase.getLoginName(issue.assignee());
        String author = GitHubIssueSynchronizerBase.getLoginName(issue.user());
        return new TeamscaleIssue(new TeamscaleIssueId(this.connectorId, issueId), issue.title(), assignee, author, issue.body(), GitHubIssueSynchronizerBase.parseTimestamp(issue.createdAt()).longValue(), Math.max(GitHubIssueSynchronizerBase.parseTimestamp(issue.updatedAt()), lowerBoundary), issue.state(), issue.closedAt() != null, issueUrl, Collections.emptyList(), Collections.emptyList(), null);
    }

    private static Long parseTimestamp(String timestamp) {
        return Instant.parse(timestamp).toEpochMilli();
    }

    private static String getLoginName(@Nullable GitHubUser user) {
        if (user == null) {
            return "";
        }
        return user.getLogin();
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder resultBuilder = this.resultBuilder();
        long minimumChangeTimestamp = Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp);
        String updatedAfter = GitHubIssueSynchronizerBase.getFormattedLastScanTimestamp(minimumChangeTimestamp);
        try {
            IStreamWithException.of(List.of(this.getRepositoryIdentifier())).withException(Exception.class).flatMap(repositoryIdentifier -> this.gitHubClient.getIssues(this.getRepositoryIdentifier(), updatedAfter)).map(issue -> this.convertIssue((GitHubIssue)issue, startTimestamp)).forEach(resultBuilder::addItem);
            return resultBuilder.build();
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Error retrieving issues: " + e.getMessage(), e);
        }
        catch (RuntimeException | StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected Exception", e);
        }
    }

    protected abstract PlatformRepositoryIdentifier getRepositoryIdentifier();
}

