/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.connectors.authentication.CredentialsConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateConfiguration;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.ICustomFieldsProvidingConnectorDescriptor;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import com.teamscale.index.issues.jira.synchronization.JiraIssueSynchronizer;
import com.teamscale.index.issues.jira.voting.JiraIssueUpdatePostAnalysisTrigger;
import com.teamscale.index.issues.model.IExternalToolIssueCustomFieldValidationResult;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@ConnectorDescriptor
public class JiraBugTrackerConnectorDescriptor
extends BugTrackerConnectorDescriptorBase
implements ICustomFieldsProvidingConnectorDescriptor {
    @ConfigExposed(name="Add to Jira issues", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Allows to add information from Teamscale to Jira.", changeRequiresReAnalysis=false)
    private final JiraIssueUpdateConfiguration issueUpdateConfig = new JiraIssueUpdateConfiguration();
    public static final String JIRA_ISSUE_UPDATE_CONFIGURATION_OPTION_NAME = "Add to Jira issues";
    @ConfigExposed(name="Cookies", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Pattern: (<domain>:)?<name>=<value>\n\nLines starting with '##' are ignored.", multilineText=true, changeRequiresReAnalysis=false)
    private final List<String> cookies = new ArrayList<String>();
    @ConfigExposed(name="Remove deleted issues", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Whether issues deleted in Jira should also be deleted in Teamscale. If enabled, the first poll per day will also check for issues deleted in Jira and remove them from Teamscale. In order to detect deleted issues, every issue has to be fetched from the Jira server. This can be a rather expensive operation, even when no issues are deleted.", changeRequiresReAnalysis=false)
    private boolean cleanupEnabled = false;
    @ExposeConnectorModule
    protected final CredentialsConnectorModule credentialsModule = new CredentialsConnectorModule(this::validateAccountDetails, false);
    private JiraClient jiraClient;

    protected JiraBugTrackerConnectorDescriptor() {
        super(EIssueTracker.JIRA);
        this.autoExpose();
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.configureTriggers(triggerCreator);
        if (!this.issueUpdateConfig.getCategories().isEmpty() && !this.issueUpdateConfig.getDestinations().isEmpty()) {
            triggerCreator.addPostRevisionAnalysisTrigger(EAnalysisState.LIVE_ANALYSIS, JiraIssueUpdatePostAnalysisTrigger.class);
            triggerCreator.addPostRevisionAnalysisTrigger(EAnalysisState.CATCHUP_LIVE_ANALYSIS, JiraIssueUpdatePostAnalysisTrigger.class);
        }
    }

    @Override
    public String getAccountIdentifier() {
        return this.credentialsModule.getCredentialsName();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return JiraIssueSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("cookies", ITriggerParameter.of(this.cookies));
        issueTrackerTriggerBuilder.setTriggerParameter("cleanup-enabled", this.cleanupEnabled);
        issueTrackerTriggerBuilder.renameIndex("work-item-cleanup-index", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
        this.setJiraInstanceTypeParameter(issueTrackerTriggerBuilder);
    }

    private void setJiraInstanceTypeParameter(TriggerBuilder issueTrackerTriggerBuilder) throws ConnectorValidationException {
        try {
            issueTrackerTriggerBuilder.setTriggerParameter("jira-instance-type-name", ITriggerParameter.of((Object)((Object)this.getJiraInstanceType())));
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private EJiraInstanceType getJiraInstanceType() throws ConnectorValidationException, ServiceCallException {
        ExternalCredentials externalCredentials = this.credentialsModule.resolveExternalCredentials(this.getContext().getExternalCredentialsProvider());
        return this.getJiraClient(externalCredentials.uri, externalCredentials.username, externalCredentials.password, this.cookies).getInstanceType();
    }

    private void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        JiraConnectorUtils.validateAccountDetails(this.getJiraClient(url, username, password, this.cookies), this.projects);
        JiraBugTrackerConnectorDescriptor.validateIssueUpdateOptions(this.issueUpdateConfig);
        try {
            this.getJiraClient(url, username, password, this.cookies).fetchAndValidateCustomFieldMapping(this.issueUpdateConfig.getDestinations());
        }
        catch (ServiceCallException | BugTrackerException e) {
            if (e.getMessage().startsWith("Jira server returned error code 404/not found")) {
                throw new ConnectorValidationException("No Jira server found or Jira version too old. We need the /api/2 endpoints introduced with Jira 5.0! Specifically, we tried to access rest/api/2/project", e);
            }
            throw new ConnectorValidationException(e);
        }
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        this.validateCustomJiraFields();
    }

    @VisibleForTesting
    void validateCustomJiraFields() throws ConnectorValidationException {
        this.checkCustomFieldsForInconsistentDuplicates();
        try {
            List<IExternalToolIssueCustomFieldValidationResult> validationResult = JiraConnectorUtils.validateCustomJiraFields((PairList<String, Boolean>)this.customFields, this.jiraClient);
            if (JiraConnectorUtils.hasValidationErrors(validationResult)) {
                throw new ConnectorValidationException("One or more custom fields could not be validated successfully: " + validationResult.stream().filter(result -> !result.isSuccessful()).map(IExternalToolIssueCustomFieldValidationResult::errorMessage).collect(Collectors.joining(StringUtils.LINE_SEPARATOR)));
            }
        }
        catch (BugTrackerException e) {
            throw new ConnectorValidationException("Failed to validate custom fields.", (Throwable)e);
        }
    }

    private void checkCustomFieldsForInconsistentDuplicates() throws ConnectorValidationException {
        Map customFieldsByName = this.customFields.groupedByFirst();
        ArrayList invalidFieldDefinitions = new ArrayList();
        customFieldsByName.forEach((name, isUserList) -> {
            if (isUserList.stream().distinct().count() > 1L) {
                invalidFieldDefinitions.add(name);
            }
        });
        if (!invalidFieldDefinitions.isEmpty()) {
            throw new ConnectorValidationException("Inconsistent duplicates in custom fields. The following custom fields are defined as both containing a username and not containing a username: '" + String.join((CharSequence)"', '", invalidFieldDefinitions) + "'. Teamscale has only limited support for fields with identical names. For more details see the documentation about importing custom fields from Jira.");
        }
    }

    @Override
    public List<ExternalToolIssueCustomField> fetchCustomFields() throws ConnectorValidationException {
        this.checkCustomFieldsForInconsistentDuplicates();
        return this.fetchCustomFields(this.credentialsModule.resolveExternalCredentials(this.getContext().getExternalCredentialsProvider()));
    }

    private List<ExternalToolIssueCustomField> fetchCustomFields(ExternalCredentials credentials) throws ConnectorValidationException {
        Map<String, List<String>> customFieldMapping;
        try {
            customFieldMapping = this.getJiraClient(credentials.uri, credentials.username, credentials.password, this.cookies).getCustomFieldMappings();
        }
        catch (ServiceCallException | BugTrackerException e) {
            throw new ConnectorValidationException("Failed to fetch custom fields.", e);
        }
        Map customFieldMap = this.customFields.toMap();
        return JiraBugTrackerConnectorDescriptor.getCustomFields(customFieldMapping, customFieldMap);
    }

    private JiraClient getJiraClient(String url, String username, String password, List<String> cookies) {
        if (this.jiraClient == null) {
            this.jiraClient = new JiraClient(url, username, password, cookies);
        }
        return this.jiraClient;
    }

    private static List<ExternalToolIssueCustomField> getCustomFields(Map<String, List<String>> customFieldNamesToIds, Map<String, Boolean> customFieldToIsUsername) {
        ArrayList<ExternalToolIssueCustomField> customFields = new ArrayList<ExternalToolIssueCustomField>();
        for (Map.Entry<String, List<String>> entry : customFieldNamesToIds.entrySet()) {
            for (String id : entry.getValue()) {
                customFields.add(new ExternalToolIssueCustomField(id, entry.getKey(), customFieldToIsUsername.getOrDefault(id, false).booleanValue(), ""));
            }
        }
        return customFields;
    }

    private static void validateIssueUpdateOptions(JiraIssueUpdateConfiguration issueUpdateConfig) throws ConnectorValidationException {
        Set destinations = issueUpdateConfig.getDestinations();
        Set categories = issueUpdateConfig.getCategories();
        if (destinations.isEmpty() && categories.isEmpty()) {
            return;
        }
        if (categories.isEmpty() || destinations.isEmpty()) {
            throw new ConnectorValidationException("Misconfigured option: at least one destination and at least one category have to be selected");
        }
    }

    public Object retrieveOptionValue(String optionName) {
        ConfigOptionDescriptorBase optionDescriptor = this.getOptionByName(optionName);
        if (optionDescriptor != null) {
            return optionDescriptor.retrieveValue(CodeScopeAware.DEFAULT_CODE_SCOPE);
        }
        return null;
    }

    public JiraIssueUpdateConfiguration getIssueUpdateConfiguration() {
        JiraIssueUpdateConfiguration jiraIssueUpdateConfiguration = (JiraIssueUpdateConfiguration)this.retrieveOptionValue(JIRA_ISSUE_UPDATE_CONFIGURATION_OPTION_NAME);
        if (jiraIssueUpdateConfiguration == null) {
            jiraIssueUpdateConfiguration = new JiraIssueUpdateConfiguration();
        }
        return jiraIssueUpdateConfiguration;
    }

    @VisibleForTesting
    void setJiraClient(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
    }
}

