/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.parser.JiraIssueParser;
import com.teamscale.index.issues.jira.synchronization.EJiraInstanceType;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public abstract class JiraInstanceAwareClient
extends JiraClient {
    private static final Integer NUMBER_OF_QUERY_THREADS = Integer.getInteger("com.teamscale.jira.threads", 2);
    private static final Duration THREAD_TIMEOUT = Duration.ofHours(2L);
    protected static final Integer ISSUE_CHUNK_SIZE = 100;
    protected static final List<String> FIELDS_TO_EXPAND = List.of("changelog", "renderedFields");
    private static final Logger LOGGER = LogManager.getLogger();

    protected JiraInstanceAwareClient(String baseUrl, @Nullable String username, String password, List<String> cookies) {
        super(baseUrl, username, password, cookies);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PairList<String, String> fetchIssues(Set<String> projects, long lastScanTimestamp, UnmodifiableList<String> fields, Set<String> issueTypes) throws BugTrackerException, ServiceCallException {
        PairList allIssues = new PairList();
        try (ExecutorService executor = WrappedExecutorServiceProducer.newFixedThreadPool((int)NUMBER_OF_QUERY_THREADS);){
            List<CompletableFuture<String>> retrievedIssueFutures = this.createAndStartIssueRetrieverCallables(executor, projects, lastScanTimestamp, fields, issueTypes);
            if (retrievedIssueFutures.isEmpty()) {
                LOGGER.info("Nothing to do");
                PairList pairList = PairList.emptyPairList();
                return pairList;
            }
            for (CompletableFuture<String> future : retrievedIssueFutures) {
                String issueJsonString = future.get(THREAD_TIMEOUT.toSeconds(), TimeUnit.SECONDS);
                allIssues.addAll(JiraIssueParser.splitJsonToIssues(issueJsonString));
            }
            LOGGER.debug("Fetched {} issue strings in total.", (Object)allIssues.size());
            PairList pairList = (PairList)LOGGER.traceExit((Object)allIssues);
            return pairList;
        }
        catch (InterruptedException | CompletionException | ExecutionException | TimeoutException e) {
            throw new BugTrackerException("Error during issue retrieval", e);
        }
    }

    protected abstract List<CompletableFuture<String>> createAndStartIssueRetrieverCallables(ExecutorService var1, Set<String> var2, long var3, UnmodifiableList<String> var5, Set<String> var6) throws ServiceCallException, CompletionException;

    public abstract Map<String, String> getProjectNamesByKey() throws BugTrackerException, ServiceCallException;

    public static String createIssueQueryString(Set<String> projects, long lastScanTimestamp, Collection<String> issueTypes) {
        StringBuilder jqlQuery = new StringBuilder();
        JiraInstanceAwareClient.appendProjectQuery(projects, jqlQuery);
        JiraInstanceAwareClient.appendIssueTypesQuery(issueTypes, jqlQuery);
        if (lastScanTimestamp > 0L) {
            JiraInstanceAwareClient.appendAndIfNonEmpty(jqlQuery);
            JiraInstanceAwareClient.appendLastScanTimestamp(lastScanTimestamp, jqlQuery);
        }
        return jqlQuery.toString();
    }

    private static void appendProjectQuery(Set<String> projects, StringBuilder jqlQuery) {
        String projectQuery = projects.isEmpty() ? "project is not empty" : projects.stream().map(project -> "project = '" + project + "'").collect(Collectors.joining(" OR "));
        jqlQuery.append('(').append(projectQuery).append(')');
    }

    private static void appendIssueTypesQuery(Collection<String> issueTypes, StringBuilder jqlQuery) {
        if (issueTypes == null || issueTypes.isEmpty()) {
            return;
        }
        String issueTypeNameQuery = issueTypes.stream().map(issueType -> "'" + issueType + "'").collect(Collectors.joining(","));
        JiraInstanceAwareClient.appendAndIfNonEmpty(jqlQuery);
        jqlQuery.append("issueType in (").append(issueTypeNameQuery).append(")");
    }

    private static void appendLastScanTimestamp(long lastScanTimestamp, StringBuilder jqlQuery) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(new Date(lastScanTimestamp));
        jqlQuery.append("updated >= ");
        jqlQuery.append(formattedDate);
    }

    private static void appendAndIfNonEmpty(StringBuilder jqlQuery) {
        if (!jqlQuery.isEmpty()) {
            jqlQuery.append(" AND ");
        }
    }

    @Override
    public JiraInstanceAwareClient toInstanceAwareClient(EJiraInstanceType jiraInstanceType) {
        throw new IllegalStateException("Conversion into an instance-aware client is not possible from a client that's already instance-aware.");
    }
}

