/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion47NormalizeRepositoryName {
    private static final String REPOSITORY_NAME_OPTION_NAME = "Repository name";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion47NormalizeRepositoryName::normalizeRepositoryName);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration normalizeRepositoryName(ConnectorConfiguration connectorConfiguration) {
        String repositoryName = connectorConfiguration.getOptionValue(REPOSITORY_NAME_OPTION_NAME);
        if (repositoryName != null) {
            connectorConfiguration.setOptionValue(REPOSITORY_NAME_OPTION_NAME, StringUtils.strip((String)repositoryName.trim(), (String)"/"));
        }
        return connectorConfiguration;
    }
}

