/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.finding;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.migration.finding.EnablementPriorityComparator;
import eu.cqse.check.framework.core.EFindingEnablement;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public abstract class ConfigurationOptionMigrationBase
implements IJsonMigration {
    protected final String oldOptionName;
    protected final String oldAnalysisGroup;
    protected final String newOptionName;
    protected final String newAnalysisGroup;
    protected String optionValue;
    private Pair<ObjectNode, ObjectNode> qualityIndicatorAndAnalysisGroup;
    protected ObjectNode options;
    private final EConflictResolutionStrategy conflictResolutionStrategy;

    protected ConfigurationOptionMigrationBase(String oldOptionName, String oldAnalysisGroup, String newOptionName, String newAnalysisGroup) {
        this(oldOptionName, oldAnalysisGroup, newOptionName, newAnalysisGroup, EConflictResolutionStrategy.EXPECT_NO_CONFLICT);
    }

    protected ConfigurationOptionMigrationBase(String oldOptionName, String oldAnalysisGroup, String newOptionName, String newAnalysisGroup, EConflictResolutionStrategy conflictResolutionStrategy) {
        this.oldOptionName = oldOptionName;
        this.oldAnalysisGroup = oldAnalysisGroup;
        this.newOptionName = newOptionName;
        this.newAnalysisGroup = newAnalysisGroup;
        this.conflictResolutionStrategy = conflictResolutionStrategy;
    }

    protected ConfigurationOptionMigrationBase(String oldOptionName, String oldAnalysisGroup) {
        this.oldOptionName = oldOptionName;
        this.oldAnalysisGroup = oldAnalysisGroup;
        this.conflictResolutionStrategy = EConflictResolutionStrategy.EXPECT_NO_CONFLICT;
        this.newOptionName = "";
        this.newAnalysisGroup = "";
    }

    public void migrateJson(ObjectNode analysisProfile) {
        if (!this.init(analysisProfile)) {
            return;
        }
        this.doMigrateJson(analysisProfile);
    }

    protected abstract void doMigrateJson(ObjectNode var1);

    protected boolean init(ObjectNode analysisProfile) {
        this.qualityIndicatorAndAnalysisGroup = ConfigurationOptionMigrationBase.getAnalysisGroupWithOption(analysisProfile, this.oldAnalysisGroup, this.oldOptionName);
        if (this.qualityIndicatorAndAnalysisGroup == null) {
            return this.isGlobalOptionMarkedForMigration(analysisProfile);
        }
        ObjectNode analysisGroup = (ObjectNode)this.qualityIndicatorAndAnalysisGroup.getSecond();
        this.options = (ObjectNode)analysisGroup.get("options");
        if (!this.options.has(this.oldOptionName)) {
            return false;
        }
        this.optionValue = this.options.get(this.oldOptionName).asText();
        return true;
    }

    private boolean isGlobalOptionMarkedForMigration(ObjectNode analysisProfile) {
        this.options = (ObjectNode)CCSMAssert.checkedCast((Object)analysisProfile.get("options"), ObjectNode.class);
        return this.options.has(this.oldOptionName);
    }

    protected void createNewOptionWithEnablement(ObjectNode analysisProfile) {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ObjectNode newGroupNode = this.getOrCreateNewAnalysisGroup(analysisProfile, factory, this.qualityIndicatorAndAnalysisGroup);
        ObjectNode newGroupOptions = (ObjectNode)newGroupNode.get("options");
        if (this.shouldInsertFindingIntoNewGroup(newGroupOptions, this.newOptionName)) {
            newGroupOptions.set(this.newOptionName, (JsonNode)factory.textNode(this.optionValue));
        }
    }

    protected void removeOption(String oldOptionName) {
        this.options.remove(oldOptionName);
        if (this.options.isEmpty()) {
            ConfigurationOptionMigrationBase.removeAnalysisGroup((ObjectNode)this.qualityIndicatorAndAnalysisGroup.getFirst(), this.oldAnalysisGroup);
        }
    }

    private static void removeAnalysisGroup(ObjectNode qualityIndicator, String groupName) {
        ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicator.get("groups"), ArrayNode.class);
        for (int j = 0; j < analysisGroups.size(); ++j) {
            if (!analysisGroups.get(j).get("name").asText().equals(groupName)) continue;
            analysisGroups.remove(j);
            return;
        }
    }

    private boolean shouldInsertFindingIntoNewGroup(ObjectNode newGroupOptions, String newOptionName) {
        EFindingEnablement mergedEnablement;
        if (!newGroupOptions.has(newOptionName) || this.conflictResolutionStrategy == EConflictResolutionStrategy.OVERWRITE) {
            return true;
        }
        if (this.conflictResolutionStrategy == EConflictResolutionStrategy.EXPECT_NO_CONFLICT) {
            throw new IllegalStateException("Failed to move " + this.oldAnalysisGroup + "/" + this.oldOptionName + " to " + this.newAnalysisGroup + "/" + newOptionName + "!");
        }
        EFindingEnablement currentEnablement = EFindingEnablement.valueOf((String)newGroupOptions.get(newOptionName).asText().toUpperCase());
        return EnablementPriorityComparator.INSTANCE.compare(currentEnablement, mergedEnablement = EFindingEnablement.valueOf((String)newGroupOptions.get(newOptionName).asText().toUpperCase())) <= 0;
    }

    private ObjectNode getOrCreateNewAnalysisGroup(ObjectNode analysisProfile, JsonNodeFactory factory, Pair<ObjectNode, ObjectNode> qualityIndicatorAndAnalysisGroup) {
        ObjectNode newGroupNode;
        Pair<ObjectNode, ObjectNode> newQualityIndicatorAndAnalysisGroup = ConfigurationOptionMigrationBase.getAnalysisGroup(analysisProfile, this.newAnalysisGroup);
        if (newQualityIndicatorAndAnalysisGroup == null) {
            newGroupNode = factory.objectNode();
            newGroupNode.set("name", (JsonNode)factory.textNode(this.newAnalysisGroup));
            ObjectNode newOptionsNode = factory.objectNode();
            newGroupNode.set("options", (JsonNode)newOptionsNode);
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)((ObjectNode)qualityIndicatorAndAnalysisGroup.getFirst()).get("groups"), ArrayNode.class);
            analysisGroups.add((JsonNode)newGroupNode);
        } else {
            newGroupNode = (ObjectNode)newQualityIndicatorAndAnalysisGroup.getSecond();
        }
        return newGroupNode;
    }

    private static Pair<ObjectNode, ObjectNode> getAnalysisGroup(ObjectNode analysisProfile, String analysisGroupName) {
        ArrayNode qualityIndicators = (ArrayNode)CCSMAssert.checkedCast((Object)analysisProfile.get("qualityIndicators"), ArrayNode.class);
        for (int i = 0; i < qualityIndicators.size(); ++i) {
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicators.get(i).get("groups"), ArrayNode.class);
            for (int j = 0; j < analysisGroups.size(); ++j) {
                if (!analysisGroups.get(j).get("name").asText().equals(analysisGroupName)) continue;
                return new Pair((Object)((ObjectNode)CCSMAssert.checkedCast((Object)qualityIndicators.get(i), ObjectNode.class)), (Object)((ObjectNode)CCSMAssert.checkedCast((Object)analysisGroups.get(j), ObjectNode.class)));
            }
        }
        return null;
    }

    private static Pair<ObjectNode, ObjectNode> getAnalysisGroupWithOption(ObjectNode analysisProfile, String analysisGroupName, String optionName) {
        if (!analysisProfile.has("qualityIndicators")) {
            return null;
        }
        ArrayNode qualityIndicators = (ArrayNode)CCSMAssert.checkedCast((Object)analysisProfile.get("qualityIndicators"), ArrayNode.class);
        for (int i = 0; i < qualityIndicators.size(); ++i) {
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicators.get(i).get("groups"), ArrayNode.class);
            for (int j = 0; j < analysisGroups.size(); ++j) {
                if (!analysisGroups.get(j).get("name").asText().equals(analysisGroupName) || !analysisGroups.get(j).get("options").has(optionName)) continue;
                return new Pair((Object)((ObjectNode)CCSMAssert.checkedCast((Object)qualityIndicators.get(i), ObjectNode.class)), (Object)((ObjectNode)CCSMAssert.checkedCast((Object)analysisGroups.get(j), ObjectNode.class)));
            }
        }
        return null;
    }

    public String getOldGroupName() {
        return this.oldAnalysisGroup;
    }

    public String getOldOptionName() {
        return this.oldOptionName;
    }

    public String getNewGroupName() {
        return this.newAnalysisGroup;
    }

    public String getNewOptionName() {
        return this.newOptionName;
    }

    public static enum EConflictResolutionStrategy {
        EXPECT_NO_CONFLICT,
        OVERWRITE,
        MERGE;

    }
}

