/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.google.common.base.Preconditions;
import com.teamscale.core.committree.ICommitTreeNode;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class CommitTreeExpansionResult {
    public final boolean fullyExpanded;
    public final boolean performedActualWork;
    public final UnmodifiableSet<ICommitTreeNode> addedNodes;

    private CommitTreeExpansionResult(boolean fullyExpanded, boolean performedActualWork, Set<ICommitTreeNode> addedNodes) {
        this.fullyExpanded = fullyExpanded;
        this.performedActualWork = performedActualWork;
        this.addedNodes = CollectionUtils.asUnmodifiable(addedNodes);
    }

    public static CommitTreeExpansionResultBuilder builder() {
        return new CommitTreeExpansionResultBuilder();
    }

    public String toString() {
        return "CommitTreeExpansionResult{fullyExpanded=" + this.fullyExpanded + ", performedActualWork=" + this.performedActualWork + ", addedNodes=" + String.valueOf(this.addedNodes) + "}";
    }

    public static class CommitTreeExpansionResultBuilder {
        private Boolean performedActualWork = null;
        private Boolean fullyExpanded = null;
        private Set<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();

        public CommitTreeExpansionResultBuilder withFullyExpanded(boolean fullyExpanded) {
            this.fullyExpanded = fullyExpanded;
            return this;
        }

        public CommitTreeExpansionResultBuilder withPerformedActualWork(boolean performedActualWork) {
            this.performedActualWork = performedActualWork;
            return this;
        }

        public CommitTreeExpansionResultBuilder withAddedNodes(Set<ICommitTreeNode> addedNodes) {
            this.addedNodes = addedNodes;
            return this;
        }

        public CommitTreeExpansionResult build() {
            Preconditions.checkNotNull((Object)this.fullyExpanded);
            Preconditions.checkNotNull((Object)this.performedActualWork);
            return new CommitTreeExpansionResult(this.fullyExpanded, this.performedActualWork, this.addedNodes);
        }
    }
}

