/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.committree;

import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AdjustAllCommits
implements ICommitTreeNodeAdjuster {
    protected final TimestampAdjustmentIndex timestampAdjustmentIndex;

    public AdjustAllCommits(TimestampAdjustmentIndex timestampAdjustmentIndex) {
        this.timestampAdjustmentIndex = timestampAdjustmentIndex;
    }

    @Override
    public void adjustTimestamps(List<CommitTreeNode> nodes) throws StorageException {
        List<CommitTreeNode> nodesToAdjust = ICommitTreeNodeAdjuster.sortNodesInAdjustmentOrder(CollectionUtils.filter(nodes, node -> node.getState() == ECommitTreeNodeState.UNPROCESSED));
        for (CommitTreeNode node2 : this.filterNodesToAdjust(nodesToAdjust)) {
            if (node2.getAdjustedTimestamp().isPresent()) continue;
            this.performAdjustment(node2);
        }
    }

    protected void performAdjustment(CommitTreeNode node) throws StorageException {
        this.timestampAdjustmentIndex.adjustTimestamp(node.getOriginalTimestamp(), node);
    }

    protected List<CommitTreeNode> filterNodesToAdjust(List<CommitTreeNode> nodesToAdjust) {
        return nodesToAdjust;
    }
}

