/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.teamscale.index.repository.git.gerrit.EGerritReviewVote;
import com.teamscale.index.repository.git.gerrit.data.CommentInput;
import com.teamscale.index.repository.git.gerrit.data.RobotCommentInput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReviewInput {
    private static final String TAG_PROPERTY = "tag";
    private static final String LABELS_PROPERTY = "labels";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String COMMENTS_PROPERTY = "comments";
    private static final String ROBOT_COMMENTS_PROPERTY = "robot_comments";
    private static final String MESSAGE_PREFIX = "Teamscale Review\n\n";
    @JsonProperty(value="tag")
    private final String tag = "autogenerated:teamscale";
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="labels")
    private final Map<String, String> labels = new HashMap<String, String>();
    @JsonProperty(value="comments")
    private final Map<String, List<CommentInput>> comments;
    @JsonProperty(value="robot_comments")
    private final Map<String, List<RobotCommentInput>> robotComments;

    @JsonCreator
    public ReviewInput(@JsonProperty(value="message") String message, @JsonProperty(value="comments") Map<String, List<CommentInput>> comments, @JsonProperty(value="robot_comments") Map<String, List<RobotCommentInput>> robotComments) {
        this.message = message;
        this.comments = comments;
        this.robotComments = robotComments;
    }

    public ReviewInput(String reviewLabel, EGerritReviewVote reviewVote, Collection<CommentInput> comments, String message, Collection<RobotCommentInput> robotComments) {
        this.labels.put(reviewLabel, reviewVote.getLabel());
        this.message = message;
        this.comments = comments.stream().collect(Collectors.toMap(CommentInput::getPath, Collections::singletonList, (comments1, comments2) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)comments1, (Iterable)comments2))));
        this.robotComments = robotComments.stream().collect(Collectors.toMap(RobotCommentInput::getPath, Collections::singletonList, (comments1, comments2) -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)comments1, (Iterable)comments2))));
    }

    public boolean hasComments() {
        return !this.comments.isEmpty();
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<String> getReviewVotes() {
        return this.labels.values();
    }
}

