/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfoWithRequirementsCheck;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubMergeRequestProvider;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRunBuilder;
import com.teamscale.index.repository.git.github.data.GitHubBuildJob;
import com.teamscale.index.repository.git.github.data.GitHubChangedFile;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.data.GitHubPullRequestComment;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.TestOnly;

public class GitHubMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<GitHubPullRequest, GitHubBuildJob> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TEXT_FIELD_LIMIT = 64000;
    private static final int ANNOTATIONS_LIMIT = 50;
    private GitHubPullRequestClient client;
    private CheckRunBuilder findingsCheckRunBuilder;
    private CheckRunBuilder testGapsCheckRunBuilder;
    private CheckRunBuilder testCoverageCheckRunBuilder;
    private CheckRun.CheckRunAnnotation[] findingsAnnotations;
    private CheckRun.CheckRunAnnotation[] testGapAnnotations;
    private PlatformRepositoryIdentifier repositoryIdentifier;
    private GitHubCheckRunIndex checkRunIndex;

    public GitHubMergeRequestAnnotationTrigger() {
    }

    @TestOnly
    protected GitHubMergeRequestAnnotationTrigger(GitHubPullRequestClient client, PlatformRepositoryIdentifier repositoryIdentifier, GitHubCheckRunIndex checkRunIndex) {
        this.client = client;
        this.repositoryIdentifier = repositoryIdentifier;
        this.checkRunIndex = checkRunIndex;
    }

    @Override
    protected MergeRequestProvider<GitHubPullRequest, GitHubBuildJob> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        String repositoryName = GitHubMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector());
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        String githubServerUrl = schedulingParameters.connector().getOptionValue("GitHub Server URL");
        GitHubAppBasedRepositoryAccessHelper<StorageException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<StorageException>(githubServerUrl, repositoryName, (GitHubInstallationIndex)globalStorage.openGlobalIndex(GitHubInstallationIndex.class), this.serverOptionIndex, (AccessTokenIndex)globalStorage.openGlobalIndex(AccessTokenIndex.class), StorageException::new, LOGGER);
        try {
            this.client = repositoryAccessHelper.createGitHubPullRequestClient();
        }
        catch (ServiceCallException e) {
            throw new StorageException("Could not create GitHub pull request client: " + e.getMessage(), (Throwable)e);
        }
        return new GitHubMergeRequestProvider(repositoryName, this.client, VotingConnectorUtils.getBuildIncludeExcludePatterns(schedulingParameters.connector()), GitHubMergeRequestAnnotationTrigger.getContextIdentifier(schedulingParameters.connector()));
    }

    @Override
    protected void handleVotingException(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequest mergeRequest, VotingException votingException) {
        LOGGER.debug("Cleaning up findings check run");
        this.postSkippedCheckRun(ECheckRunType.FINDINGS, this.findingsCheckRunBuilder, schedulingParameters.schedulingCommit(), mergeRequest, votingException);
        LOGGER.debug("Cleaning up test gaps check run");
        this.postSkippedCheckRun(ECheckRunType.TEST_GAPS, this.testGapsCheckRunBuilder, schedulingParameters.schedulingCommit(), mergeRequest, votingException);
        LOGGER.debug("Cleaning up test coverage check run");
        this.postSkippedCheckRun(ECheckRunType.TEST_COVERAGE, this.testCoverageCheckRunBuilder, schedulingParameters.schedulingCommit(), mergeRequest, votingException);
    }

    private void postSkippedCheckRun(ECheckRunType type, CheckRunBuilder checkRunBuilder, CommitDescriptor schedulingCommit, MergeRequest mergeRequest, VotingException votingException) {
        if (checkRunBuilder == null) {
            if (votingException instanceof VotingException.Skipped) {
                VotingException.Skipped skippedException = (VotingException.Skipped)votingException;
                LOGGER.debug(LoggingUtils.INTERACTION, "No clean up required: Skip happened before check run was initialized, indicating that skipping reason '{}' is not reported to the CCP.", (Object)skippedException.getReason(), (Object)skippedException);
            } else if (votingException instanceof VotingException.Error) {
                VotingException.Error errorException = (VotingException.Error)votingException;
                LOGGER.error(LoggingUtils.INTERACTION, "Clean up can not proceed, because a non-recoverable error happened before check run was initialized.", (Throwable)errorException);
            } else {
                LOGGER.error(LoggingUtils.INTERACTION, "Clean up can not proceed, because an unexpected exception occurred before the check run builder was initialized.", (Throwable)votingException);
            }
            return;
        }
        CheckRun currentCheckRun = checkRunBuilder.build();
        if (currentCheckRun.id() == null || currentCheckRun.status() != CheckRun.Status.IN_PROGRESS) {
            LOGGER.debug(LoggingUtils.INTERACTION, "No clean up required: No existing check run with status '{}' found.", (Object)CheckRun.Status.IN_PROGRESS.name(), (Object)votingException);
            return;
        }
        if (votingException instanceof VotingException.Skipped) {
            checkRunBuilder.withConclusion(CheckRun.Conclusion.SKIPPED);
        } else if (votingException instanceof VotingException.Error) {
            checkRunBuilder.withConclusion(CheckRun.Conclusion.FAILURE);
        } else {
            LOGGER.warn(LoggingUtils.INTERACTION, "Check run is still in progress but voting exception '{}' does not inform us about a conclusion. Concluding with '{}'.", (Object)votingException.getMessage(), (Object)CheckRun.Conclusion.FAILURE.name(), (Object)votingException);
            checkRunBuilder.withConclusion(CheckRun.Conclusion.FAILURE);
        }
        checkRunBuilder.withOutputTitle(votingException.getMessage());
        try {
            this.sendCheckRun(type, schedulingCommit, checkRunBuilder, null, mergeRequest.identifier);
        }
        catch (ServiceCallException | ExecutionCanceledException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = currentCheckRun::id;
            LOGGER.atError().withThrowable(e).log("Concluding check run {} failed.", supplierArray);
        }
    }

    @Override
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        this.prepareCheckRuns(schedulingParams, input);
        VotingRecord.EVotingState state = super.performVoting(schedulingParams, input);
        this.verifyNotCanceled();
        this.sendCheckRuns(schedulingParams.schedulingCommit(), schedulingParams.connector(), input.mergeRequest.identifier);
        return state;
    }

    private void prepareCheckRuns(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        GitHubCheckRunIndex checkRunIndex = this.openCheckRunIndex();
        String contextIdentifier = GitHubMergeRequestAnnotationTrigger.getContextIdentifier(schedulingParams.connector());
        this.findingsCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.FINDINGS, contextIdentifier, input, schedulingParams, checkRunIndex);
        this.testGapsCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.TEST_GAPS, contextIdentifier, input, schedulingParams, checkRunIndex);
        this.testCoverageCheckRunBuilder = GitHubMergeRequestAnnotationTrigger.initCheckRun(ECheckRunType.TEST_COVERAGE, contextIdentifier, input, schedulingParams, checkRunIndex);
    }

    private static CheckRunBuilder initCheckRun(ECheckRunType type, String contextIdentifier, MergeRequestAnnotationInput input, CommitVotingTriggerBase.SchedulingParameters schedulingParams, GitHubCheckRunIndex checkRunIndex) throws StorageException {
        String revision = input.mergeRequest.sourceHead;
        CheckRunBuilder checkRunBuilder = CheckRun.builder(type, contextIdentifier, revision, input.createMergeRequestDetailsLink(schedulingParams.linkProvider())).withConclusion(CheckRun.Conclusion.NEUTRAL);
        checkRunIndex.readId(revision, PlatformRepositoryIdentifier.fromMergeRequest(input.mergeRequest.identifier, StorageException::new), type).ifPresent(checkRunBuilder::withId);
        return checkRunBuilder;
    }

    private GitHubCheckRunIndex openCheckRunIndex() throws StorageException {
        if (this.checkRunIndex == null) {
            this.checkRunIndex = (GitHubCheckRunIndex)this.openIndexInProject(GitHubCheckRunIndex.class);
        }
        return this.checkRunIndex;
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) {
        this.findingsCheckRunBuilder.withMarkdownBadge(badgeAsMarkdown);
        this.testGapsCheckRunBuilder.withMarkdownBadge(input.buildTestGapBadgeAsMarkdown((TeamscaleProjectLinkProvider)schedulingParams.linkProvider(), this.appendSizeValuesToMarkdownImage()));
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        return this.createCommitStatusForFindings(findingsVotingInfo, schedulingParams);
    }

    private VotingRecord.EVotingState createCommitStatusForFindings(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        if (!CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(schedulingParams.connector())) {
            return VotingRecord.EVotingState.VOTED;
        }
        this.findingsCheckRunBuilder.withOutputTitle(findingsVotingInfo.getTitle());
        this.findingsCheckRunBuilder.withOutputSummary(findingsVotingInfo.toReadableDescription());
        this.findingsCheckRunBuilder.withOutputText(findingsVotingInfo.createVoteOutputDetails(schedulingParams.linkProvider(), 64000));
        if (findingsVotingInfo.isPositiveVote()) {
            this.findingsCheckRunBuilder.withConclusion(CheckRun.Conclusion.SUCCESS);
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        this.findingsCheckRunBuilder.withConclusion(CheckRun.Conclusion.ACTION_REQUIRED);
        return VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    @Override
    protected VotingRecord.EVotingState addTestGapsVote(TestGapVotingInfo testGapVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        return GitHubMergeRequestAnnotationTrigger.addTestRelatedVoteWithRequirementsCheck(testGapVotingInfo, this.testGapsCheckRunBuilder, schedulingParams.linkProvider());
    }

    @Override
    protected VotingRecord.EVotingState addTestCoverageVote(LineCoverageVotingInfo coverageVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) {
        return GitHubMergeRequestAnnotationTrigger.addTestRelatedVoteWithRequirementsCheck(coverageVotingInfo, this.testCoverageCheckRunBuilder, schedulingParams.linkProvider());
    }

    private static VotingRecord.EVotingState addTestRelatedVoteWithRequirementsCheck(IVotingInfoWithRequirementsCheck votingInfo, CheckRunBuilder checkRunBuilder, TeamscaleCommitLinkProvider linkProvider) {
        checkRunBuilder.withOutputTitle(votingInfo.getTitle());
        checkRunBuilder.withOutputSummary(votingInfo.toReadableDescription());
        checkRunBuilder.withOutputText(votingInfo.createVoteOutputDetails(linkProvider, 64000));
        if (votingInfo.isPositiveVote()) {
            checkRunBuilder.withConclusion(CheckRun.Conclusion.SUCCESS);
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = votingInfo.getVotingRequirementsCheckerResult();
        if (!votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return GitHubMergeRequestAnnotationTrigger.setStatusForUnfulfilledRequirements(checkRunBuilder, votingRequirementsCheckerResult);
        }
        checkRunBuilder.withConclusion(CheckRun.Conclusion.ACTION_REQUIRED);
        return VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    private static VotingRecord.EVotingState setStatusForUnfulfilledRequirements(CheckRunBuilder checkRunBuilder, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult) {
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE || votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.WAITING_EXTERNAL_UPLOADS) {
            checkRunBuilder.setInProgress();
        }
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE) {
            return VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD;
        }
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_GAP_VOTING_DISABLED) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        return VotingRecord.EVotingState.VOTED;
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) {
        List<IReviewComment> filteredReviewComments = this.filterReviewComments(input, reviewComments);
        Map<Boolean, List<CheckRun.CheckRunAnnotation>> findingsAndTestGapAnnotations = GitHubMergeRequestAnnotationTrigger.createAnnotations(filteredReviewComments).stream().collect(Collectors.partitioningBy(annotation -> annotation.message().startsWith("[Test Gap] ")));
        this.findingsAnnotations = (CheckRun.CheckRunAnnotation[])CollectionUtils.toArray((Collection)findingsAndTestGapAnnotations.get(false), CheckRun.CheckRunAnnotation.class);
        GitHubMergeRequestAnnotationTrigger.addAnnotationsToCheckRun(this.findingsCheckRunBuilder, this.findingsAnnotations);
        this.testGapAnnotations = (CheckRun.CheckRunAnnotation[])CollectionUtils.toArray((Collection)findingsAndTestGapAnnotations.get(true), CheckRun.CheckRunAnnotation.class);
        GitHubMergeRequestAnnotationTrigger.addAnnotationsToCheckRun(this.testGapsCheckRunBuilder, this.testGapAnnotations);
    }

    private static void addAnnotationsToCheckRun(CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations) {
        CheckRun.CheckRunAnnotation[] annotationsBatch = Arrays.copyOfRange(annotations, 0, Math.min(50, annotations.length));
        checkRunBuilder.withAnnotations(annotationsBatch);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        List<GitHubPullRequestComment> allComments = this.client.getPullRequestComments(this.repositoryIdentifier, (int)input.mergeRequest.getId());
        List aggregatedTeamscaleComments = CollectionUtils.filter(allComments, c -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(c.body()));
        for (GitHubPullRequestComment comment : aggregatedTeamscaleComments) {
            this.client.deletePullRequestComment(this.repositoryIdentifier, comment.id());
        }
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws IOException, ServiceCallException {
        this.client.createPullRequestComment(this.repositoryIdentifier, (int)pullRequestId, new GitHubPullRequestComment(commentContent, null));
    }

    private static List<CheckRun.CheckRunAnnotation> createAnnotations(List<IReviewComment> reviewComments) {
        ArrayList<CheckRun.CheckRunAnnotation> annotations = new ArrayList<CheckRun.CheckRunAnnotation>();
        for (IReviewComment reviewComment : reviewComments) {
            ElementLocation location = reviewComment.getLocation();
            Object commentContent = reviewComment.getText();
            if (((String)commentContent).length() > 64000) {
                commentContent = ((String)commentContent).substring(0, 64000 - "\u2026".length()) + "\u2026";
            }
            annotations.add(GitHubMergeRequestAnnotationTrigger.createAnnotation(reviewComment, location, (String)commentContent));
        }
        return annotations;
    }

    private static CheckRun.CheckRunAnnotation createAnnotation(IReviewComment reviewComment, ElementLocation location, String commentContent) {
        CheckRun.CheckRunAnnotation.Level annotationLevel = switch (reviewComment.getAssessment()) {
            case ETrafficLightColor.RED -> CheckRun.CheckRunAnnotation.Level.FAILURE;
            case ETrafficLightColor.YELLOW -> CheckRun.CheckRunAnnotation.Level.WARNING;
            default -> throw new IllegalStateException("Can't create a check run annotation from assessment " + String.valueOf(reviewComment.getAssessment()) + ".");
        };
        TextRegionLocation startAndEndLine = CcpCommentUtils.toTextRegionLocation(location);
        return new CheckRun.CheckRunAnnotation(location.getUniformPath(), startAndEndLine.getRawStartLine(), startAndEndLine.getRawEndLine(), annotationLevel, commentContent);
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) {
        if (commentLimitWarningFormat.equals("There are %s test gaps. This number exceeds the set limit for test gaps to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more test gap details.")) {
            this.testGapsCheckRunBuilder.withCommentLimitExceededWarning(commentLimitWarningExceededMessage);
        } else {
            this.findingsCheckRunBuilder.withCommentLimitExceededWarning(commentLimitWarningExceededMessage);
        }
    }

    private void sendCheckRuns(CommitDescriptor commit, ConnectorConfiguration connector, MergeRequestIdentifier mergeRequestIdentifier) throws ExecutionCanceledException, ServiceCallException {
        this.sendCheckRun(ECheckRunType.FINDINGS, commit, this.findingsCheckRunBuilder, this.findingsAnnotations, mergeRequestIdentifier);
        this.findingsAnnotations = null;
        if (CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector)) {
            this.sendCheckRun(ECheckRunType.TEST_GAPS, commit, this.testGapsCheckRunBuilder, this.testGapAnnotations, mergeRequestIdentifier);
        }
        this.testGapAnnotations = null;
        if (CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(connector)) {
            this.sendCheckRun(ECheckRunType.TEST_COVERAGE, commit, this.testCoverageCheckRunBuilder, null, mergeRequestIdentifier);
        }
    }

    private void sendCheckRun(ECheckRunType type, CommitDescriptor commit, CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations, MergeRequestIdentifier mergeRequestIdentifier) throws ExecutionCanceledException, ServiceCallException {
        CheckRun checkRun = checkRunBuilder.build();
        LOGGER.debug(LoggingUtils.INTERACTION, "Sending check run '{}'.", (Object)checkRun);
        long checkRunId = this.createOrUpdateCheckRun(checkRun);
        if (annotations != null && annotations.length > 50) {
            this.patchRemainingAnnotations(checkRunId, checkRunBuilder, annotations);
        }
        try {
            this.updateCheckRunInIndex(checkRunId, checkRun, type, commit, PlatformRepositoryIdentifier.fromMergeRequest(mergeRequestIdentifier, StorageException::new));
        }
        catch (StorageException e) {
            LOGGER.error("Failed to update check run with id '{}' in index.", (Object)checkRunId);
        }
    }

    private long createOrUpdateCheckRun(CheckRun checkRun) throws ServiceCallException {
        Long checkRunId = checkRun.id();
        if (checkRunId == null) {
            LOGGER.debug(LoggingUtils.INTERACTION, "Creating a new check run.");
            checkRunId = this.callCheckRunCreationService(checkRun);
        } else {
            LOGGER.debug(LoggingUtils.INTERACTION, "Updating existing check run with id '{}'.", (Object)checkRunId);
            this.callCheckRunUpdateService(checkRun, checkRunId);
        }
        return checkRunId;
    }

    private void updateCheckRunInIndex(long checkRunId, CheckRun checkRun, ECheckRunType type, CommitDescriptor commit, PlatformRepositoryIdentifier repositoryIdentifier) throws StorageException {
        GitHubCheckRunIndex checkRunIndex = this.openCheckRunIndex();
        if (checkRun.status() == CheckRun.Status.COMPLETED) {
            LOGGER.debug("Removing check run with id '{}' from index as it is completed.", (Object)checkRunId);
            checkRunIndex.removeCheckRun(checkRun.headSha(), repositoryIdentifier, type);
        } else {
            LOGGER.debug("Storing check run with id '{}' for revision '{}' and type '{}' as it is still in progress.", (Object)checkRunId, (Object)checkRun.headSha(), (Object)type.getReadableName());
            checkRunIndex.storeId(checkRun.headSha(), repositoryIdentifier, commit, type, checkRunId);
        }
    }

    protected EnumSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        return EnumSet.of(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.PLATFORM_SPECIFIC);
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ExecutionCanceledException {
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException, ExecutionCanceledException {
    }

    private List<IReviewComment> filterReviewComments(MergeRequestAnnotationInput input, List<IReviewComment> reviewComments) {
        try {
            List<GitHubChangedFile> pullRequestFiles = this.client.getPullRequestFiles(this.repositoryIdentifier, (int)input.mergeRequest.getId());
            Set pullRequestFileNames = CollectionUtils.mapToSet(pullRequestFiles, GitHubChangedFile::fileName);
            return CollectionUtils.filter(reviewComments, comment -> pullRequestFileNames.contains(comment.getLocation().getUniformPath()));
        }
        catch (ServiceCallException e) {
            LOGGER.error("Fetching the pull request files and filtering the comments to be annotated failed: " + e.getMessage(), (Throwable)e);
            return new ArrayList<IReviewComment>();
        }
    }

    protected static String getContextIdentifier(ConnectorConfiguration connector) {
        String contextIdentifier = connector.getOptionValue("Context identifier");
        return GitHubRepositoryConnectorDescriptor.computeContextIdentifier(contextIdentifier);
    }

    private void patchRemainingAnnotations(Long checkRunId, CheckRunBuilder checkRunBuilder, CheckRun.CheckRunAnnotation[] annotations) throws ExecutionCanceledException {
        int startIndex = 50;
        while (startIndex < annotations.length) {
            this.verifyNotCanceled();
            int endIndex = Math.min(startIndex + 50, annotations.length);
            CheckRun.CheckRunAnnotation[] nextAnnotationsBatch = Arrays.copyOfRange(annotations, startIndex, endIndex);
            checkRunBuilder.withAnnotations(nextAnnotationsBatch);
            this.callCheckRunUpdateService(checkRunBuilder.build(), checkRunId);
            startIndex = endIndex;
        }
    }

    private Long callCheckRunCreationService(CheckRun checkRun) throws ServiceCallException {
        try {
            return this.client.createCheckRun(this.repositoryIdentifier, checkRun);
        }
        catch (ServiceCallException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    private void callCheckRunUpdateService(CheckRun updatedCheckRun, Long checkRunId) {
        try {
            this.client.updateCheckRun(this.repositoryIdentifier, checkRunId, updatedCheckRun);
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Updating the annotations failed: {}", (Object)e.getMessage());
        }
    }

    @Override
    protected boolean shouldAddFindingsVoteOnMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        return true;
    }

    @Override
    protected boolean shouldIncludeTestGapBadge() {
        return false;
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.GITHUB;
    }
}

