/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;

@Index(name="simulink-data-dict", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={SimulinkDataDictionary.class, SimulinkBusElement.class})
public class SimulinkDataDictionaryIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-data-dict";
    private static final byte[] DATA_DICT_UNIFORM_PATH_KEY_PREFIX = new byte[]{1};
    private static final byte[] DATA_DICT_BUS_NAME_KEY_PREFIX = new byte[]{2};
    private static final byte[] DATA_DICT_BUS_TYPE_KEY_PREFIX = new byte[]{3};
    private static final byte[] DATA_DICT_FILENAME_KEY_PREFIX = new byte[]{4};
    private final Map<String, List<ShallowSimulinkBusElement>> busNamesToSignalsCache = new HashMap<String, List<ShallowSimulinkBusElement>>();

    public SimulinkDataDictionaryIndex(IStore store) {
        super(store);
    }

    public void addOrUpdateDataDictionaryFile(String uniformPath, SimulinkDataDictionary dictionary) throws StorageException {
        this.busNamesToSignalsCache.clear();
        this.deleteDataDictionaryFile(uniformPath);
        this.store.put(SimulinkDataDictionaryIndex.makeDataDictionaryUniformPathKey(uniformPath), StorageUtils.serialize((Serializable)dictionary));
        String fileName = SimulinkDataDictionaryIndex.getFilenameFromUniformPath(uniformPath);
        this.store.put(SimulinkDataDictionaryIndex.makeDataDictionaryFilenameKey(fileName), StringUtils.stringToBytes((String)uniformPath));
        PairList keyToValues = new PairList();
        for (SimulinkBus bus : dictionary.getBuses()) {
            keyToValues.add((Object)SimulinkDataDictionaryIndex.makeDataDictionaryBusNameKey(bus.getName()), (Object)StorageUtils.serialize(SimulinkDataDictionaryIndex.makeShallowBusElements((List<SimulinkBusElement>)bus.getBusElements())));
            for (SimulinkBusElement busElement : bus.getBusElements()) {
                keyToValues.add((Object)SimulinkDataDictionaryIndex.makeDataDictionaryBusTypeKey(busElement.getName()), (Object)StorageUtils.serialize((Serializable)((Object)busElement.getDataType())));
            }
        }
        this.store.put(keyToValues);
    }

    private static UnmodifiableList<ShallowSimulinkBusElement> makeShallowBusElements(List<SimulinkBusElement> busElements) {
        return CollectionUtils.asUnmodifiable(busElements.stream().map(ShallowSimulinkBusElement::fromFullBusElement).collect(Collectors.toList()));
    }

    private void deleteDataDictionaryFile(String uniformPath) throws StorageException {
        byte[] dataDictionaryUniformPathKey = SimulinkDataDictionaryIndex.makeDataDictionaryUniformPathKey(uniformPath);
        SimulinkDataDictionary simulinkDataDictionary = (SimulinkDataDictionary)StorageUtils.deserialize((byte[])this.store.get(dataDictionaryUniformPathKey));
        if (simulinkDataDictionary == null) {
            return;
        }
        this.store.remove(dataDictionaryUniformPathKey);
        for (SimulinkBus bus : simulinkDataDictionary.getBuses()) {
            this.store.remove(SimulinkDataDictionaryIndex.makeDataDictionaryBusNameKey(bus.getName()));
            this.busNamesToSignalsCache.remove(bus.getName());
            List busElements = bus.getBusElements().stream().map(SimulinkBusElement::getName).collect(Collectors.toList());
            this.store.remove(CollectionUtils.map(busElements, SimulinkDataDictionaryIndex::makeDataDictionaryBusTypeKey));
        }
        String fileName = SimulinkDataDictionaryIndex.getFilenameFromUniformPath(uniformPath);
        byte[] fileNameKey = SimulinkDataDictionaryIndex.makeDataDictionaryFilenameKey(fileName);
        this.store.remove(fileNameKey);
    }

    public void deleteDataDictionaryFiles(List<String> uniformPaths) throws StorageException {
        this.busNamesToSignalsCache.clear();
        for (String path : uniformPaths) {
            this.deleteDataDictionaryFile(path);
        }
    }

    public List<ShallowSimulinkBusElement> getSignalsOnBus(String busName) throws StorageException {
        List<ShallowSimulinkBusElement> results;
        if (this.busNamesToSignalsCache.isEmpty()) {
            this.fillCache();
        }
        if ((results = this.busNamesToSignalsCache.get(busName)) != null) {
            return results;
        }
        String busType = (String)((Object)StorageUtils.deserialize((byte[])this.store.get(SimulinkDataDictionaryIndex.makeDataDictionaryBusTypeKey(busName))));
        results = this.busNamesToSignalsCache.get(busType);
        if (results != null) {
            return results;
        }
        return Collections.singletonList(new ShallowSimulinkBusElement(busName, null));
    }

    public SimulinkDataDictionary getDataDictionaryByUniformPath(String uniformPath) throws StorageException {
        byte[] dataDictionaryUniformPathKey = SimulinkDataDictionaryIndex.makeDataDictionaryUniformPathKey(uniformPath);
        return (SimulinkDataDictionary)StorageUtils.deserialize((byte[])this.store.get(dataDictionaryUniformPathKey));
    }

    public SimulinkDataDictionary getDataDictionaryByFileName(String fileName) throws StorageException {
        byte[] fileNameKey = SimulinkDataDictionaryIndex.makeDataDictionaryFilenameKey(fileName);
        String uniformPath = StringUtils.bytesToString((byte[])this.store.get(fileNameKey));
        if (uniformPath == null) {
            return null;
        }
        return this.getDataDictionaryByUniformPath(uniformPath);
    }

    private void fillCache() throws StorageException {
        PairList busNameEntries = this.store.getEntriesStartingWith(StringUtils.bytesToString((byte[])DATA_DICT_BUS_NAME_KEY_PREFIX));
        List allKeys = CollectionUtils.map((Collection)busNameEntries.getFirstList(), value -> StringUtils.bytesToString((byte[])Arrays.copyOfRange(value, 1, ((byte[])value).length)));
        for (String key : allKeys) {
            this.busNamesToSignalsCache.put(key, this.getSignalsOnBusForCache(key));
        }
    }

    private List<ShallowSimulinkBusElement> getSignalsOnBusForCache(String busName) throws StorageException {
        ArrayList<ShallowSimulinkBusElement> results = new ArrayList<ShallowSimulinkBusElement>();
        String busType = (String)((Object)StorageUtils.deserialize((byte[])this.store.get(SimulinkDataDictionaryIndex.makeDataDictionaryBusTypeKey(busName))));
        this.getSignalsOnBusForCache(new ShallowSimulinkBusElement(busName, busType), busName, results, new HashSet<ShallowSimulinkBusElement>());
        return results;
    }

    private void getSignalsOnBusForCache(ShallowSimulinkBusElement busElement, String signalNameSoFar, List<ShallowSimulinkBusElement> results, Set<ShallowSimulinkBusElement> alreadyVisited) throws StorageException {
        alreadyVisited.add(busElement);
        List<ShallowSimulinkBusElement> busElements = this.getBusElementsOnBus(busElement);
        if (busElements == null) {
            String dataTypeWithoutPrefix = StringUtils.stripPrefix((String)busElement.busElementType, (String)"Bus: ");
            results.add(new ShallowSimulinkBusElement(signalNameSoFar, dataTypeWithoutPrefix));
            return;
        }
        for (ShallowSimulinkBusElement element : busElements) {
            if (alreadyVisited.contains(element)) continue;
            String dataTypeWithoutPrefix = StringUtils.stripPrefix((String)element.busElementType, (String)"Bus: ");
            this.getSignalsOnBusForCache(element, signalNameSoFar + "." + element.busElementName + "(" + dataTypeWithoutPrefix + ")", results, alreadyVisited);
        }
    }

    private List<ShallowSimulinkBusElement> getBusElementsOnBus(ShallowSimulinkBusElement busElement) throws StorageException {
        List busElements = (List)((Object)StorageUtils.deserialize((byte[])this.store.get(SimulinkDataDictionaryIndex.makeDataDictionaryBusNameKey(busElement.busElementName))));
        if (busElements == null && busElement.busElementType != null) {
            busElements = (List)((Object)StorageUtils.deserialize((byte[])this.store.get(SimulinkDataDictionaryIndex.makeDataDictionaryBusNameKey(busElement.busElementType))));
        }
        return busElements;
    }

    private static byte[] makeDataDictionaryUniformPathKey(String uniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_DICT_UNIFORM_PATH_KEY_PREFIX, StringUtils.stringToBytes((String)uniformPath)});
    }

    private static byte[] makeDataDictionaryFilenameKey(String fileName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_DICT_FILENAME_KEY_PREFIX, StringUtils.stringToBytes((String)fileName)});
    }

    private static byte[] makeDataDictionaryBusNameKey(String busName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_DICT_BUS_NAME_KEY_PREFIX, StringUtils.stringToBytes((String)busName)});
    }

    private static byte[] makeDataDictionaryBusTypeKey(String busName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_DICT_BUS_TYPE_KEY_PREFIX, StringUtils.stringToBytes((String)busName)});
    }

    private static String getFilenameFromUniformPath(String uniformPath) {
        return UniformPathUtils.getElementName((String)uniformPath);
    }

    public record ShallowSimulinkBusElement(String busElementName, String busElementType) implements Serializable
    {
        private static ShallowSimulinkBusElement fromFullBusElement(SimulinkBusElement busElement) {
            return new ShallowSimulinkBusElement(busElement.getName(), busElement.getDataType());
        }
    }
}

