/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.index.base.MergeCommitAnalysisStepBase;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.MergedTestInfoIndex;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.TestGapEnablementChecker;
import com.teamscale.index.testgap.TestInfoProcessorParameters;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import com.teamscale.index.testimpact.TestDeltaCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestGapInfoMerger
extends MergeCommitAnalysisStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameterObject
    private final TestInfoProcessorParameters parameters = new TestInfoProcessorParameters();

    @Override
    protected void processMergeCommit() throws Exception {
        if (EFeatureToggle.DISABLE_COVERAGE_MERGING.isEnabled() || !this.parameters.anyParentPartitionExists()) {
            return;
        }
        ParentedCommitDescriptor schedulingCommit = (ParentedCommitDescriptor)CCSMAssert.checkedCast((Object)this.getSchedulingCommit(), ParentedCommitDescriptor.class);
        UnmodifiableList parentCommits = schedulingCommit.getParentCommits();
        List branches = CollectionUtils.mapDistinct((Collection)parentCommits, CommitDescriptor::getBranchName);
        List<AssociatedMethodInfo> methodInfos = TestGapInfoMerger.getAllMethodInfos(schedulingCommit, this.parameters);
        Map<String, List<AssociatedMethodTestInfo>> testInfosPerBranch = TestGapInfoMerger.getTestInfosOfPredecessors(this.parameters.getOldLastTestedIndexes(), methodInfos, branches, (CommitDescriptor)schedulingCommit, (x$0, x$1, x$2) -> this.executeInParallelBatches(x$0, x$1, x$2));
        Map<String, Long> parentCommitTimestampsPerBranch = TestGapInfoMerger.getParentCommitTimestampsPerBranch((List<CommitDescriptor>)parentCommits);
        List<AssociatedMethodTestInfo> updatedTestInfos = TestGapInfoMerger.transferCoverageAlongSemanticallyEquivalentEdges((CommitDescriptor)schedulingCommit, branches, testInfosPerBranch, methodInfos, this.parameters.getMergedTestInfoIndex(), parentCommitTimestampsPerBranch);
        TestGapInfoMerger.storeUpdatedTestInfos(this.parameters.getNewLastTestedIndex(), updatedTestInfos);
        TestGapInfoMerger.updateNewlyCoveredMethods((CommitDescriptor)schedulingCommit, this.parameters.getNewlyCoveredMethodsIndex(), this.parameters.getExtendedResourceTypeIndex(), updatedTestInfos, this.parameters.getMethodInfoIndex(), this.parameters.getCodeScopesMappingIndex(), this.parameters.getTgaEnablementPerCodeScope());
    }

    private static Map<String, Long> getParentCommitTimestampsPerBranch(List<CommitDescriptor> parentCommits) {
        return parentCommits.stream().collect(Collectors.toMap(CommitDescriptor::getBranchName, CommitDescriptor::getTimestamp));
    }

    private static List<AssociatedMethodTestInfo> transferCoverageAlongSemanticallyEquivalentEdges(CommitDescriptor schedulingCommit, List<String> branches, Map<String, List<AssociatedMethodTestInfo>> testInfosPerBranch, List<AssociatedMethodInfo> methodInfos, MergedTestInfoIndex mergedTestInfoIndex, Map<String, Long> parentCommitTimestampsPerBranch) throws StorageException {
        ArrayList<AssociatedMethodTestInfo> allTestInfos = new ArrayList<AssociatedMethodTestInfo>();
        for (List<AssociatedMethodTestInfo> testInfos : testInfosPerBranch.values()) {
            allTestInfos.addAll(testInfos);
        }
        for (int branchIndex = 0; branchIndex < branches.size(); ++branchIndex) {
            String branch = branches.get(branchIndex);
            if (branch.equals(schedulingCommit.getBranchName())) continue;
            Map<MethodLocation, AssociatedMethodTestInfo> latestTestInfoByLocation = TestGapInfoMerger.getLatestTestInfoByLocation(testInfosPerBranch.get(branch));
            Map<CommitDescriptor, List<AssociatedMethodInfo>> testOriginCommitToMethodInfo = TestGapInfoMerger.getTestOriginCommitToMethodInfoMap(branchIndex, methodInfos, mergedTestInfoIndex, parentCommitTimestampsPerBranch.get(branch), latestTestInfoByLocation);
            allTestInfos.addAll(TestGapInfoMerger.createNewTestInfosFromBranch(schedulingCommit, mergedTestInfoIndex, testOriginCommitToMethodInfo, latestTestInfoByLocation));
        }
        return allTestInfos;
    }

    private static @NonNull Map<MethodLocation, AssociatedMethodTestInfo> getLatestTestInfoByLocation(List<AssociatedMethodTestInfo> testInfos) {
        HashMap<MethodLocation, AssociatedMethodTestInfo> latestTestInfoByLocation = new HashMap<MethodLocation, AssociatedMethodTestInfo>();
        for (AssociatedMethodTestInfo info : testInfos) {
            latestTestInfoByLocation.merge(info.getLocation(), info, (xva$0, xva$1) -> (AssociatedMethodTestInfo)ObjectUtils.max((Comparable[])new AssociatedMethodTestInfo[]{xva$0, xva$1}));
        }
        return latestTestInfoByLocation;
    }

    private static Map<CommitDescriptor, List<AssociatedMethodInfo>> getTestOriginCommitToMethodInfoMap(int branchIndex, List<AssociatedMethodInfo> methodInfos, MergedTestInfoIndex mergedTestInfoIndex, long parentCommitTimestamp, Map<MethodLocation, AssociatedMethodTestInfo> latestTestInfoByLocation) throws StorageException {
        HashMap<CommitDescriptor, List<AssociatedMethodInfo>> testOriginCommitToMethodInfo = new HashMap<CommitDescriptor, List<AssociatedMethodInfo>>();
        Map<CommitDescriptor, List<AssociatedMethodInfo>> relevantMethodInfos = methodInfos.stream().filter(MethodInfo::hadARealChangeSinceItsPredecessor).filter(methodInfo -> latestTestInfoByLocation.containsKey(methodInfo.getLocation())).collect(Collectors.groupingBy(methodInfo -> ((AssociatedMethodTestInfo)latestTestInfoByLocation.get(methodInfo.getLocation())).getCommit()));
        for (Map.Entry<CommitDescriptor, List<AssociatedMethodInfo>> associatedMethodInfosByLatestTestInfoCommit : relevantMethodInfos.entrySet()) {
            Map<String, CommitDescriptor> currentMethodKeyToOriginCommitLookup = mergedTestInfoIndex.getMethodKeyToTestOriginCommitMapping(associatedMethodInfosByLatestTestInfoCommit.getKey());
            for (AssociatedMethodInfo methodInfo2 : associatedMethodInfosByLatestTestInfoCommit.getValue()) {
                AssociatedMethodTestInfo latestTestInfo = latestTestInfoByLocation.get(methodInfo2.getLocation());
                Optional<CommitDescriptor> optionalTestOriginCommit = TestGapInfoMerger.retrieveTestOriginCommitOnBranch(branchIndex, latestTestInfo, methodInfo2, parentCommitTimestamp, currentMethodKeyToOriginCommitLookup);
                if (optionalTestOriginCommit.isEmpty()) continue;
                CommitDescriptor testOriginCommit = optionalTestOriginCommit.get();
                testOriginCommitToMethodInfo.computeIfAbsent(testOriginCommit, x -> new ArrayList());
                ((List)testOriginCommitToMethodInfo.get(testOriginCommit)).add(methodInfo2);
            }
        }
        return testOriginCommitToMethodInfo;
    }

    private static List<AssociatedMethodTestInfo> createNewTestInfosFromBranch(CommitDescriptor schedulingCommit, MergedTestInfoIndex mergedTestInfoIndex, Map<CommitDescriptor, List<AssociatedMethodInfo>> testOriginCommitToMethodInfo, Map<MethodLocation, AssociatedMethodTestInfo> latestTestInfoByLocation) throws StorageException {
        ArrayList<AssociatedMethodTestInfo> updatedTestInfos = new ArrayList<AssociatedMethodTestInfo>();
        HashMap<String, CommitDescriptor> methodKeysToTestOrigins = new HashMap<String, CommitDescriptor>();
        for (CommitDescriptor testOriginCommit : testOriginCommitToMethodInfo.keySet()) {
            List<AssociatedMethodInfo> methodInfosForTestOriginCommit = testOriginCommitToMethodInfo.get(testOriginCommit);
            for (AssociatedMethodInfo methodInfo : methodInfosForTestOriginCommit) {
                AssociatedMethodTestInfo latestTestInfo = latestTestInfoByLocation.get(methodInfo.getLocation());
                updatedTestInfos.add(latestTestInfo.withAssociatedMethodAndCommit(methodInfo, schedulingCommit));
                methodKeysToTestOrigins.put(methodInfo.getKey(), testOriginCommit);
            }
        }
        if (!methodKeysToTestOrigins.isEmpty()) {
            mergedTestInfoIndex.setTestOriginsForCommit(schedulingCommit, methodKeysToTestOrigins);
        }
        return updatedTestInfos;
    }

    private static List<AssociatedMethodInfo> getAllMethodInfos(ParentedCommitDescriptor schedulingCommit, TestInfoProcessorParameters parameters) throws StorageException, CommitResolutionException {
        HashSet uniformPathsToLoadMethodInfosFrom = CollectionUtils.unionSet((Collection)parameters.getMethodInfoDelta().getAddedOrChangedKeys(), (Collection[])new Collection[]{parameters.getMethodInfoDelta().getDeletedKeys()});
        List<ParentedCommitDescriptor> commitsToBeMerged = TestDeltaCalculator.getUnmergedCommits(schedulingCommit, parameters.getCommitDescriptorIndex());
        Set<UniformPath> filesWithNewlyCoveredMethods = parameters.getNewlyCoveredMethodsIndex().getUniformPathsWithNewlyCoveredMethodsInCommits(commitsToBeMerged, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED);
        uniformPathsToLoadMethodInfosFrom.addAll(filesWithNewlyCoveredMethods);
        ArrayList<UniformPath> uniformPaths = new ArrayList<UniformPath>(uniformPathsToLoadMethodInfosFrom);
        return parameters.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(uniformPaths);
    }

    private static Map<String, List<AssociatedMethodTestInfo>> getTestInfosOfPredecessors(List<MethodLastTestedIndex> oldMethodLastTestedIndexes, List<AssociatedMethodInfo> methods, List<String> branches, CommitDescriptor schedulingCommit, ExecuteInParallelBatchesFunction executeInParallelBatchesExecutor) throws StorageException, ExecutionException {
        HashMap<String, List<AssociatedMethodTestInfo>> timestampsForMethodKeys = new HashMap<String, List<AssociatedMethodTestInfo>>();
        for (int i = 0; i < branches.size(); ++i) {
            Map<MethodLocation, AssociatedMethodInfo> predecessorsToMethodsMap = TestGapInfoMerger.getPredecessorsOnBranch(methods, branches.get(i), schedulingCommit);
            List<AssociatedMethodTestInfo> predecessorTimestampsAndUpdateKey = TestGapInfoMerger.getPredecessorTimestampsAndUpdateKey(predecessorsToMethodsMap, oldMethodLastTestedIndexes.get(i), executeInParallelBatchesExecutor);
            timestampsForMethodKeys.put(branches.get(i), predecessorTimestampsAndUpdateKey);
        }
        return timestampsForMethodKeys;
    }

    private static List<AssociatedMethodTestInfo> getPredecessorTimestampsAndUpdateKey(Map<MethodLocation, AssociatedMethodInfo> predecessorsToMethodsMap, MethodLastTestedIndex oldMethodLastTestedIndex, ExecuteInParallelBatchesFunction executeInParallelBatchesExecutor) throws StorageException, ExecutionException {
        List<AssociatedMethodTestInfo> timestampsForMethodKeys = Collections.synchronizedList(new ArrayList());
        executeInParallelBatchesExecutor.executeParallelBatches(new ArrayList<MethodLocation>(predecessorsToMethodsMap.keySet()), methodLocations -> {
            for (AssociatedMethodTestInfo timestamp : oldMethodLastTestedIndex.getTimestampsForMethodKeys((Collection<MethodLocation>)methodLocations)) {
                AssociatedMethodInfo method = (AssociatedMethodInfo)predecessorsToMethodsMap.get(timestamp.getLocation());
                AssociatedMethodTestInfo updatedMethodTimestamp = timestamp.withAssociatedMethod(method);
                timestampsForMethodKeys.add(updatedMethodTimestamp);
            }
        }, 100);
        return timestampsForMethodKeys;
    }

    private static Map<MethodLocation, AssociatedMethodInfo> getPredecessorsOnBranch(List<AssociatedMethodInfo> methods, String branch, CommitDescriptor schedulingCommit) {
        HashMap<MethodLocation, AssociatedMethodInfo> predecessors = new HashMap<MethodLocation, AssociatedMethodInfo>();
        for (AssociatedMethodInfo method : methods) {
            Pair<CommitDescriptor, String> predecessorInBranch = method.extractPredecessorInBranch(branch);
            if (predecessorInBranch != null && method.getLastInfoUpdateCommit().equals((Object)schedulingCommit)) {
                predecessors.put(MethodLocation.fromIndexKey((String)predecessorInBranch.getSecond()), method);
                continue;
            }
            predecessors.put(MethodLocation.fromIndexKey(method.getKey()), method);
        }
        return predecessors;
    }

    private static void storeUpdatedTestInfos(MethodLastTestedIndex newMethodLastTestedIndex, List<AssociatedMethodTestInfo> updatedTestInfos) throws StorageException {
        Map<MethodLastTestedIndex.AccessKey, CommitDescriptor> maxima = updatedTestInfos.stream().collect(Collectors.toMap(info -> new MethodLastTestedIndex.AccessKey(info.getPartition(), info.getUniformPath(), info.getAssociatedRegion()), AssociatedMethodTestInfo::getCommit, CommitDescriptor::max));
        PairList lastTestedTimestamps = new PairList(maxima);
        newMethodLastTestedIndex.setLastMergedTimestamps((PairList<MethodLastTestedIndex.AccessKey, CommitDescriptor>)lastTestedTimestamps);
    }

    private static void updateNewlyCoveredMethods(CommitDescriptor schedulingCommit, NewlyCoveredMethodsIndex newlyCoveredMethodsIndex, ExtendedResourceTypeIndex extendedResourceTypeIndex, List<AssociatedMethodTestInfo> updatedTestInfos, MethodInfoIndex methodInfoIndex, CodeScopesMappingIndex codeScopeMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        PairList uniformPathsAndRegions = new PairList(updatedTestInfos.size());
        for (AssociatedMethodTestInfo testInfo : updatedTestInfos) {
            uniformPathsAndRegions.add((Object)testInfo.getUniformPath(), (Object)testInfo.getAssociatedRegion());
        }
        Map<MethodLocation, MethodInfo> result = methodInfoIndex.getMethodInfoMapForExactPaths((PairList<UniformPath, OffsetBasedRegion>)uniformPathsAndRegions);
        List<UniformPath> uniformPaths = updatedTestInfos.stream().map(AssociatedMethodTestInfo::getUniformPath).distinct().toList();
        Set<UniformPath> testCodePaths = extendedResourceTypeIndex.getTestCodePaths((Collection<UniformPath>)uniformPaths);
        TestGapEnablementChecker tgaEnablementChecker = new TestGapEnablementChecker(uniformPaths, codeScopeMappingIndex, tgaEnablementPerCodeScope);
        HashMap<String, List<MethodLocation>> newlyCoveredMethodsByPartition = new HashMap<String, List<MethodLocation>>();
        for (AssociatedMethodTestInfo testInfo : updatedTestInfos) {
            MethodLocation methodLocation = testInfo.getLocation();
            MethodInfo methodInfo = result.get(methodLocation);
            if (methodInfo == null) {
                LOGGER.error("Could not find method info for region " + String.valueOf(methodLocation) + " at " + String.valueOf(schedulingCommit));
                continue;
            }
            if (testInfo.getTimestamp() <= methodInfo.getLastChangedTimestamp() || !methodInfo.isRelevantForTgaTreemap(testCodePaths.contains(methodLocation.getUniformPath()), tgaEnablementChecker.isTgaEnabled(methodLocation.getUniformPath()))) continue;
            String partition = testInfo.getPartition();
            newlyCoveredMethodsByPartition.putIfAbsent(partition, new ArrayList());
            ((List)newlyCoveredMethodsByPartition.get(partition)).add(methodLocation);
        }
        newlyCoveredMethodsIndex.storeMethodsAsNewlyCovered(schedulingCommit, newlyCoveredMethodsByPartition, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED);
        newlyCoveredMethodsIndex.storeMethodsAsNewlyCovered(schedulingCommit, newlyCoveredMethodsByPartition, NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
    }

    private static Optional<CommitDescriptor> retrieveTestOriginCommitOnBranch(int branchIndex, AssociatedMethodTestInfo testInfo, AssociatedMethodInfo methodInfo, long parentCommitTimestamp, Map<String, CommitDescriptor> currentMethodKeyToOriginCommitLookup) {
        Optional<Pair<String, Long>> lastChangeTimestampAndBranchOfPredecessor = TestGapInfoMerger.getLastChangeTimestampForPredecessorOnBranch(branchIndex, methodInfo);
        if (lastChangeTimestampAndBranchOfPredecessor.isEmpty()) {
            return Optional.empty();
        }
        long lastChangeTimestampOfPredecessorOnBranch = (Long)lastChangeTimestampAndBranchOfPredecessor.get().getSecond();
        long testTimestamp = testInfo.getTimestamp();
        if (testTimestamp < lastChangeTimestampOfPredecessorOnBranch) {
            return Optional.empty();
        }
        if (testTimestamp > parentCommitTimestamp && !CommitDescriptorMerger.isInMergeWindow((long)(testTimestamp - parentCommitTimestamp))) {
            return Optional.empty();
        }
        String lastChangeBranch = (String)lastChangeTimestampAndBranchOfPredecessor.get().getFirst();
        Pair<CommitDescriptor, String> predecessorInBranchWithKey = methodInfo.extractPredecessorInBranch(lastChangeBranch);
        if (predecessorInBranchWithKey == null) {
            LOGGER.error("Could not find a predecessor for " + String.valueOf(methodInfo) + " on branch " + lastChangeBranch + " for commit " + String.valueOf(methodInfo.getLastInfoUpdateCommit()));
            return Optional.empty();
        }
        String methodKeyOfPredecessorInBranch = (String)predecessorInBranchWithKey.getSecond();
        CommitDescriptor testTargetCommit = testInfo.getCommit();
        CommitDescriptor testOriginCommit = currentMethodKeyToOriginCommitLookup.get(methodKeyOfPredecessorInBranch);
        if (testOriginCommit != null) {
            return Optional.of(testOriginCommit);
        }
        return Optional.of(testTargetCommit);
    }

    private static Optional<Pair<String, Long>> getLastChangeTimestampForPredecessorOnBranch(int branchIndex, AssociatedMethodInfo methodInfo) {
        Optional<CommitDescriptor> parentOnSemanticallyEquivalentEdge = methodInfo.getSemanticallyEquivalentPredecessorCommitForBranchIndex(branchIndex);
        return parentOnSemanticallyEquivalentEdge.map(commit -> new Pair((Object)commit.getBranchName(), (Object)methodInfo.getLastChangeTimestampForPredecessorCommit((CommitDescriptor)commit)));
    }
}

