# Description
Line break multiple parameters

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#line-break-multiple-parameters

# Examples
**Bad example**
```abap
method( parameter1 = value parameter2 = value ).
```

**Good example**
```abap
method( parameter1 = value
        parameter2 = value ).
```

# Clean ABAP Code Style Guide
```ABAP
DATA(sum) = add_two_numbers( value_1 = 5
                             value_2 = 6 ).
```

Yes, this wastes space.
However, otherwise, it's hard to spot where one parameter ends and the next starts:

```ABAP
" anti-pattern
DATA(sum) = add_two_numbers( value_1 = 5 value_2 = 6 ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/line_break_multiple_parameters) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
