# Description
Don't declare inline in optional branches

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#dont-declare-inline-in-optional-branches

Considered optional branches:
* inside `IF`/`ELSEIF`/`ELSE`
* inside `LOOP`
* inside `WHILE`
* inside `CASE`/`WHEN`, `CASE TYPE OF`
* inside `DO`
* inside `SELECT loops`

Not considered optional branches:
* `TRY`/`CATCH`/`CLEANUP`

# Clean ABAP Code Style Guide
```ABAP
" anti-pattern
IF has_entries = abap_true.
  DATA(value) = 1.
ELSE.
  value = 2.
ENDIF.
```
This works fine because ABAP handles inline declarations as if they were at the beginning of the method.
However, it is extremely confusing for readers,
especially if the method is longer and you don't spot the declaration right away.
In this case, break with inlining and put the declaration up-front:
```ABAP
DATA value TYPE i.
IF has_entries = abap_true.
  value = 1.
ELSE.
  value = 2.
ENDIF.
```
> Read more in _Chapter 5: Formatting: Vertical Distance: Variable Declarations_ of [Robert C. Martin's _Clean Code_].

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/no_inline_in_optional_branches) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
