
**DO** reference only in-scope identifiers in doc comments.

When a developer writes a reference with angle brackets within a doc comment,
the angle brackets are interpreted as HTML. The text within pairs of opening and
closing angle brackets generally get swallowed by the browser, and will not be
displayed.

You can use a code block or code span to wrap the text containing angle
brackets. You can also replace `<` with `&lt;` and `>` with `&gt;`.

**BAD:**
```dart
/// Text List<int>.
/// Text [List<int>].
/// <assignment> -> <variable> = <expression>
```

**GOOD:**
```dart
/// Text `List<int>`.
/// `<assignment> -> <variable> = <expression>`
/// <http://foo.bar.baz>
```
