Ensures component's `changeDetection` is set to `ChangeDetectionStrategy.OnPush`

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import type { ChangeDetectionStrategy } from '@angular/core';

@Component({})
~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import { Component } from '@angular/core';
const changeDetection = 'template';
@Component({ [changeDetection]: '' })
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({ changeDetection: undefined })
                              ~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import * as ng from '@angular/core';
@Component({ 'changeDetection': ChangeDetectionStrategy.Default })
                                                        ~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import type { OnInit } from '@angular/core';
@Component({ ['changeDetection']: ChangeDetectionStrategy.Default })
                                                          ~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import ng from '@angular/core';
@Component({ [`changeDetection`]: ChangeDetectionStrategy.Default })
                                                          ~~~~~~~
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Component(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  changeDetection: ChangeDetectionStrategy.OnPush,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  'changeDetection': changeDetection,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const changeDetection = ChangeDetectionStrategy.Default;
@Component({
  changeDetection,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
function changeDetection() {
  return ChangeDetectionStrategy.OnPush;
}

@Component({
  ['changeDetection']: changeDetection(),
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  [`changeDetection`]: ChangeDetectionStrategy.OnPush,
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [Foo]
})
class Test {}
```

</details>
