[Accessibility] Ensures that the mouse events `mouseout` and `mouseover` are accompanied by `focus` and `blur` events respectively. Coding for the keyboard is important for users with physical disabilities who cannot use a mouse, AT compatibility, and screenreader users. See more at https://www.w3.org/WAI/WCAG21/Understanding/keyboard

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div (mouseover)="onMouseOver()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div (mouseout)="onMouseOut()" (focus)="onFocus()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<app-test (mouseover)="onMouseOver()"></app-test>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-test (mouseout)="onMouseOut()"></app-test>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div (mouseover)="onMouseOver()" (focus)="onFocus()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div (mouseout)="onMouseOut()" (blur)="onBlur()"></div>
```

</details>
