<h2>Why is this an issue?</h2>
<p><code>break;</code> is an unstructured control flow statement which makes code harder to read.</p>
<p>Ideally, every loop should have a single termination condition.</p>
<h3>Noncompliant code example</h3>
<pre>
int i = 0;
while (true)
{
  if (i == 10)
  {
    break;      // Non-Compliant
  }

  Console.WriteLine(i);
  i++;
}
</pre>
<h3>Compliant solution</h3>
<pre>
int i = 0;
while (i != 10) // Compliant
{
  Console.WriteLine(i);
  i++;
}
</pre>

