<h2>Why is this an issue?</h2>
<p>Types are declared in namespaces in order to prevent name collisions and as a way to organize them into the object hierarchy. Types that are
defined outside any named namespace are in a global namespace that cannot be referenced in code.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Foo // Noncompliant
{
}

public struct Bar // Noncompliant
{
}
</pre>
<h3>Compliant solution</h3>
<pre>
namespace SomeSpace
{
    public class Foo
    {
    }

    public struct Bar
    {
    }
}
</pre>

