<h2>Why is this an issue?</h2>
<p>When the syntax <code>new Guid()</code> (i.e. parameterless instantiation) is used, it must be that one of three things is wanted:</p>
<ol>
  <li> An empty GUID, in which case <code>Guid.Empty</code> is clearer. </li>
  <li> A randomly-generated GUID, in which case <code>Guid.NewGuid()</code> should be used. </li>
  <li> A new GUID with a specific initialization, in which case the initialization parameter is missing. </li>
</ol>
<p>This rule raises an issue when a parameterless instantiation of the <code>Guid</code> struct is found.</p>
<h3>Noncompliant code example</h3>
<pre>
public void Foo()
{
    var g1 = new Guid();    // Noncompliant - what's the intent?
    Guid g2 = new();        // Noncompliant
    var g3 = default(Guid); // Noncompliant
    Guid g4 = default;      // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
public void Foo(byte[] bytes)
{
    var g1 = Guid.Empty;
    var g2 = Guid.NewGuid();
    var g3 = new Guid(bytes);
}
</pre>

