<p>ASP.NET 1.1+ comes with a feature called <em>Request Validation</em>, preventing the server to accept content containing un-encoded HTML. This
feature comes as a first protection layer against Cross-Site Scripting (XSS) attacks and act as a simple Web Application Firewall (WAF) rejecting
requests potentially containing malicious content.</p>
<p>While this feature is not a silver bullet to prevent all XSS attacks, it helps to catch basic ones. It will for example prevent <code>&lt;script
type="text/javascript" src="https://malicious.domain/payload.js"&gt;</code> to reach your Controller.</p>
<p>Note: <em>Request Validation</em> feature being only available for ASP.NET, no Security Hotspot is raised on ASP.NET Core applications.</p>
<h2>Ask Yourself Whether</h2>
<ul>
  <li> the developer doesn’t know the impact to deactivate the Request Validation feature </li>
  <li> the web application accepts user-supplied data </li>
  <li> all user-supplied data are not validated </li>
</ul>
<p>There is a risk if you answered yes to any of those questions.</p>
<h2>Recommended Secure Coding Practices</h2>
<ul>
  <li> Activate the Request Validation feature for all HTTP requests </li>
</ul>
<h2>Sensitive Code Example</h2>
<p>At Controller level:</p>
<pre>
[ValidateInput(false)]
public ActionResult Welcome(string name)
{
  ...
}
</pre>
<p>At application level, configured in the Web.config file:</p>
<pre>
&lt;configuration&gt;
   &lt;system.web&gt;
      &lt;pages validateRequest="false" /&gt;
      ...
      &lt;httpRuntime requestValidationMode="0.0" /&gt;
   &lt;/system.web&gt;
&lt;/configuration&gt;
</pre>
<h2>Compliant Solution</h2>
<p>At Controller level:</p>
<pre>
[ValidateInput(true)]
public ActionResult Welcome(string name)
{
  ...
}
</pre>
<p>or</p>
<pre>
public ActionResult Welcome(string name)
{
  ...
}
</pre>
<p>At application level, configured in the Web.config file:</p>
<pre>
&lt;configuration&gt;
   &lt;system.web&gt;
      &lt;pages validateRequest="true" /&gt;
      ...
      &lt;httpRuntime requestValidationMode="4.5" /&gt;
   &lt;/system.web&gt;
&lt;/configuration&gt;
</pre>
<h2>See</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A03_2021-Injection/">Top 10 2021 Category A3 - Injection</a> </li>
  <li> <a
  href="https://docs.microsoft.com/en-us/dotnet/api/system.web.configuration.httpruntimesection.requestvalidationmode?view=netframework-4.8">HttpRuntimeSection.RequestValidationMode Property</a> </li>
  <li> <a href="https://owasp.org/www-community/ASP-NET_Request_Validation">OWASP ASP.NET Request Validation</a> </li>
  <li> <a href="https://cheatsheetseries.owasp.org/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.html">OWASP Cheat Sheet</a> - XSS
  Prevention Cheat Sheet </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A7_2017-Cross-Site_Scripting_(XSS)">Top 10 2017 Category A7 - Cross-Site Scripting
  (XSS)</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/79">CWE-79 - Improper Neutralization of Input During Web Page Generation ('Cross-site
  Scripting')</a> </li>
</ul>

