﻿## SA1013

<table>
<tr>
  <td>TypeName</td>
  <td>SA1013ClosingBracesMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1013</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A closing brace within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a closing brace is not correct.

A closing brace should always be followed by a single space, unless it is the last character on the line, or unless it is followed by a closing parenthesis, a comma, or a semicolon.

A closing brace should always be preceded by a single space, unless it is the first character on the line.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the closing brace follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1013:ClosingBracesMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1013 // ClosingBracesMustBeSpacedCorrectly
#pragma warning restore SA1013 // ClosingBracesMustBeSpacedCorrectly
```
