﻿## SA1617

<table>
<tr>
  <td>TypeName</td>
  <td>SA1617VoidReturnValueMustNotBeDocumented</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1617</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A C# code element does not contain a return value, or returns void, but the documentation header for the element contains a `<returns>` tag.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if an element which returns void contains a `<returns>` tag within its documentation header.

## How to fix violations

To fix a violation of this rule, remove the `<returns>` tag from the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Prints the given name.
/// </summary>
/// <param name="firstName">The first name.</param>
/// <param name="lastName">The last name.</param>
public void PrintNames(string firstName, string lastName)
{
    Console.WriteLine(firstName + " " + lastName);
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1617:VoidReturnValueMustNotBeDocumented", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1617 // VoidReturnValueMustNotBeDocumented
#pragma warning restore SA1617 // VoidReturnValueMustNotBeDocumented
```
