<h2>Why is this an issue?</h2>
<p>Declaring a variable only to immediately return or throw it is considered a bad practice because it adds unnecessary complexity to the code. This
practice can make the code harder to read and understand, as it introduces an extra step that doesn’t add any value. Instead of declaring a variable
and then immediately returning or throwing it, it is generally better to return or throw the value directly. This makes the code cleaner, simpler, and
easier to understand.</p>
<h2>How to fix it</h2>
<p>Declaring a variable only to immediately return or throw it is considered a bad practice because it adds unnecessary complexity to the code. To fix
the issue, return or throw the value directly.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public long computeDurationInMilliseconds() {
  long duration = (((hours * 60) + minutes) * 60 + seconds) * 1000;
  return duration;
}
```
<h4>Compliant solution</h4>

```java
public long computeDurationInMilliseconds() {
  return (((hours * 60) + minutes) * 60 + seconds) * 1000;
}
```
<h4>Noncompliant code example</h4>

```java
public void doSomething() {
  RuntimeException myException = new RuntimeException();
  throw myException;
}
```
<h4>Compliant solution</h4>

```java
public void doSomething() {
  throw new RuntimeException();
}
```