<h2>Why is this an issue?</h2>
<p>Since an <code>int</code> is a 32-bit variable, shifting by more than +/-31 is confusing at best and an error at worst. When the runtime shifts
32-bit integers, it uses the lowest 5 bits of the shift count operand. In other words, shifting an <code>int</code> by 32 is the same as shifting it
by 0, and shifting it by 33 is the same as shifting it by 1.</p>
<p>Similarly, when shifting 64-bit integers, the runtime uses the lowest 6 bits of the shift count operand and shifting <code>long</code> by 64 is the
same as shifting it by 0, and shifting it by 65 is the same as shifting it by 1.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public int shift(int a) {
  int x = a >> 32; // Noncompliant
  return a << 48;  // Noncompliant
}
```
<h4>Compliant solution</h4>

```java
public int shift(int a) {
  int x = a >> 31;
  return a << 16;
}
```