<h2>Why is this an issue?</h2>
<p>Variable declaration is the process of creating a new variable and specifying its name. JavaScript provides three ways to declare variables: using
the <code>var</code>, <code>let</code>, and <code>const</code> keywords.</p>
<ul>
  <li> The <code>var</code> keyword is used to declare function-scoped or global-scoped variables, i.e. they are accessible throughout the function or
  the entire program, respectively. </li>
  <li> The <code>let</code> keyword is used to declare block-scoped variables, that is, variables accessible only within the nearest curly braces
  block where it is defined. </li>
  <li> The <code>const</code> keyword is used to declare variables that are constant, meaning their values cannot be reassigned. </li>
</ul>
<p>Explicitly declaring variables improves code readability and maintainability. It makes it clear to other developers that you are creating a new
variable and sets expectations about its scope. It also helps catch typos and avoid potential issues caused by accidentally reusing variable
names.</p>
<p>If you assign a value to a variable without declaring it with <code>var</code>, <code>let</code>, or <code>const</code>, JavaScript treats it as an
implicit global variable. Implicit globals can lead to unintended consequences and make it difficult to track and manage variables. They can cause
naming conflicts, make code harder to understand, and introduce bugs that are hard to trace.</p>

```js
function f() {
  i = 1; // Noncompliant: i is global

  for (j = 0; j < array.length; j++) { // Noncompliant: j is global too
    // ...
  }
}
```
<p>You should explicitly declare all the variables of your code. Use the <code>const</code> keyword if the variable is only assigned once and the
<code>let</code> keyword otherwise.</p>

```js
function f() {
  const i = 1;

  for (let j = 0; j < array.length; j++) {
    // ...
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Variable">Variable</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_types#declaring_variables">Declaring
  variables</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_types#variable_scope">Variable scope</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var">var</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let">let</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const">const</a> </li>
</ul>