<h2>Why is this an issue?</h2>
<p>A loop with at most one iteration is equivalent to the use of an <code>if</code> statement to conditionally execute one piece of code. No developer
expects to find such a use of a loop statement. If the initial intention of the author was really to conditionally execute one piece of code, an
<code>if</code> statement should be used instead.</p>
<p>At worst that was not the initial intention of the author and so the body of the loop should be fixed to use the nested <code>return</code>,
<code>break</code> or <code>throw</code> statements in a more appropriate way.</p>
<h3>Noncompliant code example</h3>

```php
for ($i = 0; $i < 10; $i++) { // Noncompliant
  echo "i is $i";
  break;
}
...
for ($i = 0; $i < 10; $i++) { // Noncompliant
  if ($i == $x) {
    break;
  } else {
    echo "i is $i";
    return;
  }
}
```
<h3>Compliant solution</h3>

```php
for ($i = 0; $i < 10; $i++) {
  echo "i is $i";
}
...
for ($i = 0; $i < 10; $i++) {
  if ($i == $x) {
    break;
  } else {
    echo "i is $i";
  }
}
```