<h2>Why is this an issue?</h2>
<p>Altering or bypassing the accessibility of classes, methods, or fields through reflection violates the encapsulation principle. This can break the
internal contracts of the accessed target and lead to maintainability issues and runtime errors.</p>
<p>This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a
field value.</p>

```php
$reflectionMethod = new ReflectionMethod(MyClass::class, "privateMethode");
$reflectionMethod->setAccessible(true);

$reflectionProperty = new ReflectionProperty(MyClass::class, "privateProperty");
$reflectionProperty->setAccessible(true);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://en.wikipedia.org/wiki/Encapsulation_(computer_programming)">Wikipedia definition of Encapsulation</a> </li>
</ul>