<h2>Why is this an issue?</h2>
<p>Default parameter values allow callers to specify as many or as few arguments as they want while getting the same functionality and minimizing
boilerplate, wrapper code, making a function easier to use.</p>
<p>All function parameters with default values should be declared after the function parameters without default values. Otherwise, it makes it
impossible for callers to take advantage of defaults; they must re-specify the defaulted values or pass <code>undefined</code> to be able to specify
the non-default parameters.</p>

```ts
function multiply(a = 1, b) { // Noncompliant: parameter with default value should be last
  return a*b;
}

let x = multiply(1, 42); // Cannot benefit from default value
```
<p>Reorder the function parameters so that the ones with default values come after the ones without default values.</p>

```ts
function multiply(b, a = 1) {
  return a*b;
}

let x = multiply(42);
```
<h3>Exceptions</h3>
<p>When writing Redux reducers, there is a convention to use default argument syntax to provide initial state (first argument), while action (second
argument) is mandatory. A reducer may be called with <code>undefined</code> as the state value when the application is being initialized.</p>

```ts
// Use the initialState as a default value
export default function appReducer(state = initialState, action) {
  switch (action.type) {
    default:
      return state;
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Default_parameters">Default parameters</a>
  </li>
  <li> Redux Documentation - <a href="https://redux.js.org/tutorials/fundamentals/part-3-state-actions-reducers#writing-reducers">Writing Reducers</a>
  </li>
</ul>