<h2>Why is this an issue?</h2>
<p>Using operator pairs (<code>=+</code>, <code>=-</code>, or <code>=!</code>) that look like reversed single operators (<code>+=</code>,
<code>-=</code> or <code>!=</code>) is confusing. They compile and run but do not produce the same result as their mirrored counterpart.</p>

```ts
let target =-5;
let num = 3;

target =- num;  // Noncompliant: target = -3. Is that the expected behavior?
target =+ num; // Noncompliant: target = 3
```
<p>This rule raises an issue when <code>=+</code>, <code>=-</code>, or <code>=!</code> are used without any space between the operators and when there
is at least one whitespace after.</p>
<p>Replace the operators with a single one if that is the intention</p>

```ts
let target =-5;
let num = 3;

target -= num;  // target = -8
```
<p>Or fix the spacing to avoid confusion</p>

```ts
let target =-5;
let num = 3;

target = - num;  // target = -3
```