<h2>Why is this an issue?</h2>
<p>When a reluctant (or lazy) quantifier is followed by a pattern that can match the empty string or directly by the end of the regex, it will always
match zero times for <code>*?</code> or one time for <code>+?</code>. If a reluctant quantifier is followed directly by the end anchor
(<code>$</code>), it behaves indistinguishably from a greedy quantifier while being less efficient.</p>
<p>This is likely a sign that the regex does not work as intended.</p>
<h3>Noncompliant code example</h3>

```ts
str.split(/.*?x?/); // Noncompliant, this will behave just like "x?"
/^.*?$/.test(str); // Noncompliant, replace with ".*"
```
<h3>Compliant solution</h3>

```ts
str.split(/.*?x/);
/^.*$/.test(str);
```