<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) is a set of attributes that define ways to make web content and web applications more accessible to
people with disabilities. The <code>aria-hidden</code> attribute is used to indicate that an element and all of its descendants are not visible or
perceivable to any user as implemented by assistive technologies.</p>
<p>However, when <code>aria-hidden</code> is used on a focusable element, it can create a confusing and inaccessible experience for screen reader
users. This is because the element will still be included in the tab order, so a screen reader user can navigate to it, but it will not be announced
by the screen reader due to the <code>aria-hidden</code> attribute.</p>
<p>This rule ensures that focusable elements are not hidden from screen readers using the <code>aria-hidden</code> attribute.</p>
<h2>How to fix it</h2>
<p>Check if the element is focusable. Focusable elements should not have <code>aria-hidden</code> attribute.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<button aria-hidden="true">Click me</button>
```
<p>Remove <code>aria-hidden</code> attribute.</p>
<h4>Compliant solution</h4>

```ts
<button>Click me</button>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-hidden">aria-hidden attribute
  (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>