<h2>Why is this an issue?</h2>
<p>The <code>accesskey</code> attribute, despite its potential utility, is fraught with numerous issues that limit its effectiveness and
usability:</p>
<ul>
  <li> Screen readers' implementation of <code>accesskey</code> largely depends on the browser used, as they rely on browsers for much of their
  functionality. Some screen readers may repeatedly indicate the <code>accesskey</code> value each time the element is encountered, potentially
  causing unnecessary repetition and noise for the user. </li>
  <li> Conflicts between <code>accesskey</code> shortcuts and other keyboard shortcuts, such as those of browsers, operating systems, assistive
  technologies, or browser extensions, are frequent. This overlap can lead to uncertainty and potentially trigger unintended actions, causing user
  confusion. </li>
  <li> While keyboard shortcuts are vital for screen reader functionality, conflicts can disable either the screen reader or <code>accesskey</code>
  shortcuts. Typically, screen reader shortcuts take precedence, disabling the <code>accesskey</code> but preserving screen reader functionality.
  However, this can cause confusion for users attempting to activate an <code>accesskey</code>. </li>
  <li> No keystroke combinations can guarantee zero conflicts with all browsers, assistive technologies, or operating systems, particularly
  considering foreign languages. For instance, an <code>accesskey</code> shortcut that works in an English browser may conflict in the same browser
  set in another language due to different menu naming conventions. </li>
  <li> While using numerals instead of letters for keyboard shortcuts could reduce conflicts, it’s not a foolproof solution. There’s no standard
  correlation between numbers and web functions, which could lead to user confusion. </li>
  <li> Unlike the Windows environment that highlights keyboard shortcuts in menus, web pages or applications lack a standardized method to notify
  users about available <code>accesskey</code> shortcuts. </li>
</ul>
<p>Given these concerns, it is generally recommended to avoid using <code>accesskey</code>s.</p>

```ts
function div() {
    return <div accessKey="h" />;
}
```
<p>Do not use <code>accesskey</code>s at all.</p>

```ts
function div() {
    return <div />;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/accesskey">accesskey</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/accesskey">Accessibility concerns</a> </li>
</ul>