This check detects pragma directives that disable compiler warnings.

# Why is This a Problem?

Disabled compiler warnings can be problematic as warnings report risky constructions or suggest there may have been an error.

# How Can I Resolve This?

Warnings should be fixed if possible. If a single warning can not be fixed, then we recommend to mark the corresponding Teamscale finding as tolerated.

## Examples

```cpp
// Visual Studio, disable warning messages of 4507 and 4034 globally.
#pragma warning( disable : 4507 34 )
```
```cpp
// GCC/Clang, disable warning messages "-Wunused-parameter" globally.
#pragma GCC diagnostic ignored "-Wunused-parameter"
```

# Where Can I Learn More?

## Guidelines

- [Using the GNU Compiler Collection: 6.62.13 - Diagnostic Pragmas](https://gcc.gnu.org/onlinedocs/gcc/Diagnostic-Pragmas.html)
- [C/C++ Preprocessor Reference: Warning Pragma](https://docs.microsoft.com/en-us/cpp/preprocessor/warning?view=msvc-170)