Integer division (rounding down):
``` python
# Python 2 only:
assert 2 / 3 == 0
```
  
``` python
# Python 2 and 3:
assert 2 // 3 == 0
```
  
"True division" (float division):
``` python
# Python 3 only:
assert 3 / 2 == 1.5
```
  
``` python
# Python 2 and 3:
from __future__ import division    # (at top of module)

assert 3 / 2 == 1.5
```
  
"Old division" (i.e. compatible with Py2 behaviour):
``` python
# Python 2 only:
a = b / c            # with any types
```
  
``` python
# Python 2 and 3:
from past.utils import old_div

a = old_div(b, c)    # always same as / on Py2
```
  

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)