Having multiple statements on the same line can decrease code readability by making it easier to overlook some statements.
Instead, consider placing each statement on a separate line to enhance readability.

# What Does This Check Look For?
This check identifies instances where more than one statement is located on the same line.

# Why is This a Problem?
Ensuring that developers can easily understand, debug, and precisely pinpoint issues with the codebase is essential. 
Placing multiple statements on the same line can impact code comprehension and maintainability. 
Developers often scan code quickly, and having multiple statements on a single line increases the chance of missing important operations or logic, leading to misunderstanding of the code's behavior. 
This practice can also complicate debugging and code reviews, as it's harder to pinpoint the exact location of an issue or to understand the logic flow at a glance.

# How Can I Resolve This?
Place each statement on its own line. 
This simple change can make a difference in how others can understand and work with your code.
By doing so, you ensure that each action the code performs is clearly visible and distinct, facilitating quicker comprehension and effective problem-solving.
Additionally, adopting and consistently following a coding standard that promotes this practice makes the code style more uniform and can prevent readability and maintainability issues from occurring in the future.

# Examples
## Non-Compliant
```C
int num = 0; char word[] = "Hello!"; // multiple statements
        
while ((num += 1) <= 5) {
    say(word);
    if (num == 5) { say("bye!"); } // multiple statements
}

switch(num) {
    case 0:
        foo();
        break;
    case 1:
        bar();
        break;
    case 2:
        fooBar(); return; // multiple statements
    default:
        break;
}

void setFoo(int val) { foo = val; } // Ok

void setFooBar(int val) { foo = val; bar = val; } // multiple statements
```
## Compliant
```C
int num = 0; 
char word[] = "Hello!";
        
while ((num += 1) <= 5) {
    say(word);
    if (num == 5) { 
        say("bye!");
    }
}

switch(num) {
    case 0:
        foo();
        break;
    case 1:
        bar();
        break;
    case 2:
        fooBar(); 
        return;
    default:
        break;
}

void setFoo(int val) { foo = val; }

void setFooBar(int val) { 
    foo = val; 
    bar = val; 
}
```