Creating pre-defined `BigInteger`/`BigDecimal` objects redundantly can lead to unnecessary performance overhead. Instead, refer directly to the pre-defined constants like `BigInteger.ZERO` or `BigDecimal.TEN`.

# What Does This Check Look For?

This check identifies instances where objects of `BigInteger` or `BigDecimal` are created with values for which constants like `ZERO`, `ONE`, and `TEN` already exist.

# Why is This a Problem?

The unnecessary instantiation of `BigInteger` or `BigDecimal` objects for values that have pre-defined constants incurs an avoidable performance cost due to object creation overhead.

# How Can I Resolve This?

Replace the explicit instantiation of `BigInteger` and `BigDecimal` objects with the matching pre-defined constants (`ZERO`, `ONE`, `TEN`). This enhances performance by removing unnecessary object creation.