/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.incremental.DependencyValueClass;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ArchitectureAnalysisUtils {
    static List<String> filterArchitectureFiles(List<String> keys) {
        return keys.stream().filter(UniformPathUtils::isArchitectureFile).toList();
    }

    public static ArchitectureDefinition getArchitectureDefinition(TokenElementInfo architectureElement) throws ConQATException {
        String uniformPath = Objects.requireNonNull(architectureElement).getUniformPath();
        CCSMAssert.isTrue((boolean)UniformPathUtils.isArchitectureFile((String)uniformPath), (String)("Expecting architecture file, but was: " + uniformPath));
        return ArchitectureDefinitionReader.read(uniformPath, architectureElement.getText());
    }

    public static List<Dependency> convertDependencyObjects(ArchitectureDefinition architecture, List<DependencyValueClass> valueClasses) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (DependencyValueClass dependencyDTO : valueClasses) {
            ComponentNode source = architecture.getComponentByName(dependencyDTO.getSourceComponentName());
            ComponentNode target = architecture.getComponentByName(dependencyDTO.getTargetComponentName());
            Dependency dependency = new Dependency(source, target, dependencyDTO.getPolicyType(), dependencyDTO.getAssessmentType(), dependencyDTO.getDependencies(), dependencyDTO.getToleratedDependencies());
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public static void addThirdPartyDependencies(TypeIndex typeIndex, Map<String, ListMap<String, ElementLocation>> result, TypeDependencies typeDependencies) throws StorageException {
        List<String> types = typeDependencies.getDependencies().stream().filter(t -> !result.containsKey(t)).toList();
        List<String> missingTypes = typeIndex.getMissingTypes(types);
        for (String type : missingTypes) {
            result.put(type, (ListMap<String, ElementLocation>)new ListMap());
        }
    }

    private ArchitectureAnalysisUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

